/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.util.List;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.formulation.common.EnvironmentVars;

public class EnvironmentVarsSerializer
extends StdSerializer<EnvironmentVars> {
    private final boolean isXml;

    public EnvironmentVarsSerializer(boolean isXml) {
        this(null, isXml);
    }

    public EnvironmentVarsSerializer(Class<EnvironmentVars> t, boolean isXml) {
        super(t);
        this.isXml = isXml;
    }

    public void serialize(EnvironmentVars value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        List<Object> choices = value.getChoices();
        if (this.isXml && jsonGenerator instanceof ToXmlGenerator) {
            ToXmlGenerator xmlGenerator = (ToXmlGenerator)jsonGenerator;
            this.serializeXml(choices, xmlGenerator);
        } else {
            this.serializeJson(choices, jsonGenerator);
        }
    }

    private void serializeXml(List<Object> choices, ToXmlGenerator xmlGenerator) throws IOException {
        xmlGenerator.writeFieldName("environmentVars");
        if (choices.size() == 1 && choices.get(0) instanceof String) {
            xmlGenerator.writeStartObject();
            xmlGenerator.writeStringField("value", (String)choices.get(0));
            xmlGenerator.writeEndObject();
        } else {
            xmlGenerator.writeStartObject();
            for (Object choice : choices) {
                if (choice instanceof Property) {
                    xmlGenerator.writeFieldName("environmentVar");
                    xmlGenerator.writeStartObject();
                    Property prop = (Property)choice;
                    xmlGenerator.setNextIsAttribute(true);
                    xmlGenerator.writeFieldName("name");
                    xmlGenerator.writeString(prop.getName());
                    xmlGenerator.setNextIsAttribute(false);
                    xmlGenerator.setNextIsUnwrapped(true);
                    xmlGenerator.writeStringField("", prop.getValue());
                    xmlGenerator.writeEndObject();
                    continue;
                }
                if (!(choice instanceof String)) continue;
                xmlGenerator.writeFieldName("value");
                xmlGenerator.writeString((String)choice);
            }
            xmlGenerator.writeEndObject();
        }
    }

    private void serializeJson(List<Object> choices, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeFieldName("environmentVars");
        jsonGenerator.writeStartArray();
        if (choices.size() == 1 && choices.get(0) instanceof String) {
            jsonGenerator.writeString((String)choices.get(0));
        } else {
            for (Object choice : choices) {
                if (choice instanceof Property) {
                    jsonGenerator.writeStartObject();
                    Property property = (Property)choice;
                    jsonGenerator.writeStringField("name", property.getName());
                    jsonGenerator.writeStringField("value", property.getValue());
                    jsonGenerator.writeEndObject();
                    continue;
                }
                if (!(choice instanceof String)) continue;
                jsonGenerator.writeString((String)choice);
            }
        }
        jsonGenerator.writeEndArray();
    }

    public Class<EnvironmentVars> handledType() {
        return EnvironmentVars.class;
    }
}

