/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.List;
import org.cyclonedx.model.AttachmentText;
import org.cyclonedx.model.formulation.common.InputType;
import org.cyclonedx.util.deserializer.AbstractDataTypeDeserializer;

public class InputTypeDeserializer
extends AbstractDataTypeDeserializer<InputType> {
    public InputType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        InputType inputType = new InputType();
        this.setSourceAndTarget(node, inputType);
        this.createInputDataInfo(node, inputType, jsonParser, deserializationContext);
        this.setProperties(node, inputType);
        return inputType;
    }

    private void createInputDataInfo(JsonNode node, InputType inputType, JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        if (node.has("resource")) {
            this.setResource(node, inputType);
        } else if (node.has("parameters")) {
            JsonNode parametersNode = node.get("parameters");
            List parameters = (List)this.objectMapper.convertValue((Object)parametersNode, (TypeReference)new TypeReference<List<InputType.Parameter>>(){});
            inputType.setParameters(parameters);
        } else if (node.has("environmentVars")) {
            this.setEnvironmentVars(node, inputType, jsonParser, ctxt);
        } else if (node.has("data")) {
            JsonNode dataNode = node.get("data");
            AttachmentText data = (AttachmentText)this.objectMapper.treeToValue((TreeNode)dataNode, AttachmentText.class);
            inputType.setData(data);
        }
    }
}

