/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cyclonedx.model.vulnerability.Vulnerability;
import org.cyclonedx.util.deserializer.AffectDeserializer;
import org.cyclonedx.util.deserializer.DeserializerUtils;

public class AffectsDeserializer
extends JsonDeserializer<List<Vulnerability.Affect>> {
    private final AffectDeserializer affectDeserializer = new AffectDeserializer();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public List<Vulnerability.Affect> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        return this.parseAffects(node.has("target") ? node.get("target") : node, p, ctxt);
    }

    private List<Vulnerability.Affect> parseAffects(JsonNode node, JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayList<Vulnerability.Affect> affects = new ArrayList<Vulnerability.Affect>();
        ArrayNode nodes = DeserializerUtils.getArrayNode(node, this.objectMapper);
        for (JsonNode affectNode : nodes) {
            affects.add(this.parseAffect(affectNode, p, ctxt));
        }
        return affects;
    }

    private Vulnerability.Affect parseAffect(JsonNode node, JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonParser affectParser = node.traverse(p.getCodec());
        affectParser.nextToken();
        return this.affectDeserializer.deserialize(affectParser, ctxt);
    }
}

