/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.formulation.common.AbstractType;
import org.cyclonedx.model.formulation.common.EnvironmentVars;
import org.cyclonedx.model.formulation.common.ResourceReferenceChoice;
import org.cyclonedx.util.deserializer.EnvironmentVarsDeserializer;

public abstract class AbstractDataTypeDeserializer<T extends AbstractType>
extends JsonDeserializer<T> {
    protected final ObjectMapper objectMapper = new ObjectMapper();
    private final EnvironmentVarsDeserializer environmentVarsDeserializer = new EnvironmentVarsDeserializer();

    protected void setEnvironmentVars(JsonNode node, AbstractType data, JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        JsonNode nodes = node.get("environmentVars");
        JsonParser nodeParser = nodes.traverse(jsonParser.getCodec());
        EnvironmentVars envVar = this.environmentVarsDeserializer.deserialize(nodeParser, ctxt);
        data.setEnvironmentVars(envVar);
    }

    protected void setReference(JsonNode node, String fieldName, AbstractType type) throws JsonProcessingException {
        if (node.has(fieldName)) {
            JsonNode fieldNode = node.get(fieldName);
            ResourceReferenceChoice reference = (ResourceReferenceChoice)this.objectMapper.treeToValue((TreeNode)fieldNode, ResourceReferenceChoice.class);
            if ("source".equals(fieldName)) {
                type.setSource(reference);
            } else if ("target".equals(fieldName)) {
                type.setTarget(reference);
            }
        }
    }

    protected void setSourceAndTarget(JsonNode node, AbstractType type) throws JsonProcessingException {
        this.setReference(node, "source", type);
        this.setReference(node, "target", type);
    }

    protected void setResource(JsonNode node, AbstractType type) throws JsonProcessingException {
        JsonNode resourceNode = node.get("resource");
        ResourceReferenceChoice resource = (ResourceReferenceChoice)this.objectMapper.treeToValue((TreeNode)resourceNode, ResourceReferenceChoice.class);
        type.setResource(resource);
    }

    protected void setProperties(JsonNode node, AbstractType type) throws JsonProcessingException {
        if (node.has("properties")) {
            JsonNode propertiesNode = node.get("properties");
            List properties = (List)this.objectMapper.convertValue((Object)propertiesNode, (TypeReference)new TypeReference<List<Property>>(){});
            type.setProperties(properties);
        }
    }
}

