/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"signers", "chain", "algorithm", "keyId", "publicKey", "certificatePath", "excludes", "value"})
public class Signature {
    @JsonAlias(value={"chain"})
    private List<Signature> signers;
    private Algorithm algorithm;
    private String keyId;
    private PublicKey publicKey;
    private List<String> certificatePath;
    private List<String> excludes;
    private String value;

    public List<Signature> getSigners() {
        return this.signers;
    }

    public void setSigners(List<Signature> signers) {
        this.signers = signers;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public List<String> getCertificatePath() {
        return this.certificatePath;
    }

    public void setCertificatePath(List<String> certificatePath) {
        this.certificatePath = certificatePath;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static class PublicKey {
        private Kty kty;
        private Crv crv;
        private String x;
        private String y;
        private String e;
        private String n;

        public Kty getKty() {
            return this.kty;
        }

        public void setKty(Kty kty) {
            this.kty = kty;
        }

        public Crv getCrv() {
            return this.crv;
        }

        public void setCrv(Crv crv) {
            this.crv = crv;
        }

        public String getX() {
            return this.x;
        }

        public void setX(String x) {
            this.x = x;
        }

        public String getY() {
            return this.y;
        }

        public void setY(String y) {
            this.y = y;
        }

        public String getE() {
            return this.e;
        }

        public void setE(String e) {
            this.e = e;
        }

        public String getN() {
            return this.n;
        }

        public void setN(String n) {
            this.n = n;
        }

        public static enum Crv {
            P_256("P-256"),
            P_384("P-384"),
            P_521("P-521");

            private final String name;

            public String getCrvName() {
                return this.name;
            }

            private Crv(String name) {
                this.name = name;
            }

            public static Crv fromString(String text) {
                for (Crv c : Crv.values()) {
                    if (!c.name.equals(text)) continue;
                    return c;
                }
                return null;
            }
        }

        public static enum Kty {
            EC("EC"),
            OKP("OKP"),
            RSA("RSA");

            private final String name;

            public String getKtyName() {
                return this.name;
            }

            private Kty(String name) {
                this.name = name;
            }

            public static Kty fromString(String text) {
                for (Kty k : Kty.values()) {
                    if (!k.name.equals(text)) continue;
                    return k;
                }
                return null;
            }
        }
    }

    public static enum Algorithm {
        RS256("RS256"),
        RS384("RS384"),
        RS512("RS512"),
        PS256("PS256"),
        PS384("PS384"),
        PS512("PS512"),
        ES256("ES256"),
        ES384("ES384"),
        ES512("ES512"),
        ED25519("Ed25519"),
        ED448("Ed448"),
        HS256("HS256"),
        HS384("HS384"),
        HS512("HS512");

        private final String name;

        public String getAlgorithmName() {
            return this.name;
        }

        private Algorithm(String name) {
            this.name = name;
        }

        public static Algorithm fromString(String text) {
            for (Algorithm a : Algorithm.values()) {
                if (!a.name.equals(text)) continue;
                return a;
            }
            return null;
        }
    }
}

