/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.cyclonedx.Version;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExtensibleElement;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Lifecycles;
import org.cyclonedx.model.OrganizationalContact;
import org.cyclonedx.model.OrganizationalEntity;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.Tool;
import org.cyclonedx.model.VersionFilter;
import org.cyclonedx.model.metadata.ToolInformation;
import org.cyclonedx.util.deserializer.LicenseDeserializer;
import org.cyclonedx.util.deserializer.LifecycleDeserializer;
import org.cyclonedx.util.deserializer.MetadataDeserializer;
import org.cyclonedx.util.serializer.CustomDateSerializer;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"timestamp", "lifecycles", "tools", "authors", "component", "manufacturer", "manufacture", "supplier", "licenses", "properties"})
@JsonDeserialize(using=MetadataDeserializer.class)
public class Metadata
extends ExtensibleElement {
    @JsonSerialize(using=CustomDateSerializer.class)
    @VersionFilter(value=Version.VERSION_12)
    private Date timestamp = new Date();
    @VersionFilter(value=Version.VERSION_15)
    @JsonProperty(value="lifecycles")
    @JsonDeserialize(using=LifecycleDeserializer.class)
    @JacksonXmlElementWrapper(localName="lifecycles")
    @JacksonXmlProperty(localName="lifecycle")
    private Lifecycles lifecycles;
    @VersionFilter(value=Version.VERSION_12)
    @Deprecated
    private List<Tool> tools;
    @JacksonXmlElementWrapper(localName="tools")
    @JacksonXmlProperty(localName="tool")
    @VersionFilter(value=Version.VERSION_15)
    private ToolInformation toolInformation;
    @VersionFilter(value=Version.VERSION_12)
    private List<OrganizationalContact> authors;
    @VersionFilter(value=Version.VERSION_12)
    private Component component;
    @VersionFilter(value=Version.VERSION_16)
    @JsonProperty(value="manufacturer")
    private OrganizationalEntity manufacturer;
    @Deprecated
    @VersionFilter(value=Version.VERSION_12)
    private OrganizationalEntity manufacture;
    @VersionFilter(value=Version.VERSION_12)
    private OrganizationalEntity supplier;
    @VersionFilter(value=Version.VERSION_13)
    private LicenseChoice licenses;
    @VersionFilter(value=Version.VERSION_13)
    private List<Property> properties;

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @JacksonXmlElementWrapper(localName="tools")
    @JacksonXmlProperty(localName="tool")
    @JsonIgnore
    public List<Tool> getTools() {
        return this.tools;
    }

    public void setTools(List<Tool> tools) {
        this.tools = tools;
    }

    public void addTool(Tool tool) {
        if (this.tools == null) {
            this.tools = new ArrayList<Tool>();
        }
        this.tools.add(tool);
    }

    @JacksonXmlElementWrapper(localName="authors")
    @JacksonXmlProperty(localName="author")
    public List<OrganizationalContact> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<OrganizationalContact> authors) {
        this.authors = authors;
    }

    public void addAuthor(OrganizationalContact author) {
        if (this.authors == null) {
            this.authors = new ArrayList<OrganizationalContact>();
        }
        this.authors.add(author);
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    @Deprecated
    public OrganizationalEntity getManufacture() {
        return this.manufacture;
    }

    @Deprecated
    public void setManufacture(OrganizationalEntity manufacture) {
        this.manufacture = manufacture;
    }

    public OrganizationalEntity getSupplier() {
        return this.supplier;
    }

    public void setSupplier(OrganizationalEntity supplier) {
        this.supplier = supplier;
    }

    @Deprecated
    public LicenseChoice getLicenseChoice() {
        return this.getLicenses();
    }

    @Deprecated
    @JsonIgnore
    public void setLicenseChoice(LicenseChoice licenseChoice) {
        this.setLicenses(licenseChoice);
    }

    @JsonDeserialize(using=LicenseDeserializer.class)
    public LicenseChoice getLicenses() {
        return this.licenses;
    }

    @JacksonXmlElementWrapper(useWrapping=false)
    public void setLicenses(LicenseChoice licenses) {
        this.licenses = licenses;
    }

    @JacksonXmlElementWrapper(localName="properties")
    @JacksonXmlProperty(localName="property")
    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public void addProperty(Property property) {
        if (this.properties == null) {
            this.properties = new ArrayList<Property>();
        }
        this.properties.add(property);
    }

    public Lifecycles getLifecycles() {
        return this.lifecycles;
    }

    public void setLifecycles(Lifecycles lifecycles) {
        this.lifecycles = lifecycles;
    }

    @JacksonXmlElementWrapper(localName="tools")
    @JacksonXmlProperty(localName="tool")
    public ToolInformation getToolChoice() {
        return this.toolInformation;
    }

    public void setToolChoice(ToolInformation toolInformation) {
        this.toolInformation = toolInformation;
    }

    public OrganizationalEntity getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(OrganizationalEntity manufacturer) {
        this.manufacturer = manufacturer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata metadata = (Metadata)o;
        return Objects.equals(this.timestamp, metadata.timestamp) && Objects.equals(this.authors, metadata.authors) && Objects.equals(this.component, metadata.component) && Objects.equals(this.manufacture, metadata.manufacture) && Objects.equals(this.supplier, metadata.supplier) && Objects.equals(this.licenses, metadata.licenses) && Objects.equals(this.lifecycles, metadata.lifecycles) && Objects.equals(this.toolInformation, metadata.toolInformation) && Objects.equals(this.properties, metadata.properties);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.toolInformation, this.authors, this.component, this.manufacture, this.supplier, this.licenses, this.properties, this.lifecycles);
    }
}

