/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.volumes;

import hudson.Extension;
import hudson.model.Descriptor;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import org.csanchez.jenkins.plugins.kubernetes.volumes.PodVolume;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class HostPathVolume
extends PodVolume {
    private String mountPath;
    private String hostPath;

    @DataBoundConstructor
    public HostPathVolume(String hostPath, String mountPath) {
        this.hostPath = hostPath;
        this.mountPath = mountPath;
    }

    @Override
    public Volume buildVolume(String volumeName) {
        return ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(volumeName)).withNewHostPath(this.getHostPath())).build();
    }

    @Override
    public String getMountPath() {
        return this.mountPath;
    }

    public String getHostPath() {
        return this.hostPath;
    }

    public String toString() {
        return "HostPathVolume [mountPath=" + this.mountPath + ", hostPath=" + this.hostPath + "]";
    }

    @Extension
    @Symbol(value={"hostPathVolume"})
    public static class DescriptorImpl
    extends Descriptor<PodVolume> {
        public String getDisplayName() {
            return "Host Path Volume";
        }
    }
}

