/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.util.CopyOnWriteMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateSource;

@Extension
public class PodTemplateMap {
    private static final Logger LOGGER = Logger.getLogger(PodTemplateMap.class.getName());
    private Map<String, List<PodTemplate>> map = new CopyOnWriteMap.Hash();

    public static PodTemplateMap get() {
        return (PodTemplateMap)ExtensionList.lookup(PodTemplateMap.class).get(PodTemplateMap.class);
    }

    @Nonnull
    public List<PodTemplate> getTemplates(@Nonnull KubernetesCloud cloud) {
        return Collections.unmodifiableList(this.getOrCreateTemplateList(cloud));
    }

    private List<PodTemplate> getOrCreateTemplateList(@Nonnull KubernetesCloud cloud) {
        CopyOnWriteArrayList podTemplates = this.map.get(cloud.name);
        return podTemplates == null ? new CopyOnWriteArrayList() : podTemplates;
    }

    public void addTemplate(@Nonnull KubernetesCloud cloud, @Nonnull PodTemplate podTemplate) {
        List<PodTemplate> list = this.getOrCreateTemplateList(cloud);
        list.add(podTemplate);
        this.map.put(cloud.name, list);
    }

    public void removeTemplate(@Nonnull KubernetesCloud cloud, @Nonnull PodTemplate podTemplate) {
        this.getOrCreateTemplateList(cloud).remove(podTemplate);
    }

    @Extension
    public static class PodTemplateSourceImpl
    extends PodTemplateSource {
        @Override
        @Nonnull
        public List<PodTemplate> getList(@Nonnull KubernetesCloud cloud) {
            return PodTemplateMap.get().getTemplates(cloud);
        }
    }
}

