/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.model;

import hudson.Extension;
import hudson.model.Descriptor;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import org.csanchez.jenkins.plugins.kubernetes.model.TemplateEnvVar;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class KeyValueEnvVar
extends TemplateEnvVar {
    private static final long serialVersionUID = 5205795416963333813L;
    private String value;

    @DataBoundConstructor
    public KeyValueEnvVar(String key, String value) {
        super(key);
        this.value = value;
    }

    @Override
    public EnvVar buildEnvVar() {
        return ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName(this.getKey())).withValue(this.getValue())).build();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return "KeyValueEnvVar [getValue()=" + this.getValue() + ", getKey()=" + this.getKey() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof KeyValueEnvVar)) {
            return false;
        }
        KeyValueEnvVar other = (KeyValueEnvVar)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Extension
    @Symbol(value={"envVar"})
    public static class DescriptorImpl
    extends Descriptor<TemplateEnvVar> {
        public String getDisplayName() {
            return "Environment Variable";
        }
    }
}

