/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import io.fabric8.kubernetes.api.model.ContainerPort;
import java.io.Serializable;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PortMapping
extends AbstractDescribableImpl<PortMapping>
implements Serializable {
    private String name;
    private Integer containerPort;
    private Integer hostPort;

    @DataBoundConstructor
    public PortMapping(String name, Integer containerPort) {
        this.name = name;
        this.containerPort = containerPort;
    }

    public PortMapping(String name, Integer containerPort, Integer hostPort) {
        this.name = name;
        this.containerPort = containerPort;
        this.hostPort = hostPort;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @DataBoundSetter
    public void setContainerPort(Integer containerPort) {
        this.containerPort = containerPort;
    }

    public Integer getContainerPort() {
        return this.containerPort;
    }

    @DataBoundSetter
    public void setHostPort(Integer hostPort) {
        this.hostPort = hostPort;
    }

    public Integer getHostPort() {
        return this.hostPort;
    }

    public ContainerPort toPort() {
        ContainerPort p = new ContainerPort();
        p.setName(this.name);
        p.setContainerPort(this.containerPort);
        if (this.hostPort != null) {
            p.setHostPort(this.hostPort);
        }
        return p;
    }

    public String toString() {
        return String.format("%s,%d", this.name, this.containerPort);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.containerPort == null ? 0 : this.containerPort);
        result = 31 * result + (this.hostPort == null ? 0 : this.hostPort);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortMapping other = (PortMapping)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.containerPort == null ? other.containerPort != null : !this.containerPort.equals(other.containerPort)) {
            return false;
        }
        return !(this.hostPort == null ? other.hostPort != null : !this.hostPort.equals(other.hostPort));
    }

    @Extension
    @Symbol(value={"portMapping"})
    public static class DescriptorImpl
    extends Descriptor<PortMapping> {
        public String getDisplayName() {
            return "Container Exposed Ports";
        }
    }
}

