/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.Secret;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.kubernetes.credentials.TokenProducer;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class KubernetesFactoryAdapter {
    private static final Logger LOGGER = Logger.getLogger(KubernetesFactoryAdapter.class.getName());
    private static final int DEFAULT_CONNECT_TIMEOUT = 5;
    private static final int DEFAULT_READ_TIMEOUT = 15;
    private final String serviceAddress;
    private final String namespace;
    @CheckForNull
    private final String caCertData;
    @CheckForNull
    private final StandardCredentials credentials;
    private final boolean skipTlsVerify;
    private final int connectTimeout;
    private final int readTimeout;
    private final int maxRequestsPerHost;

    public KubernetesFactoryAdapter(String serviceAddress, @CheckForNull String caCertData, @CheckForNull String credentials, boolean skipTlsVerify) {
        this(serviceAddress, null, caCertData, credentials, skipTlsVerify);
    }

    public KubernetesFactoryAdapter(String serviceAddress, String namespace, @CheckForNull String caCertData, @CheckForNull String credentials, boolean skipTlsVerify) {
        this(serviceAddress, namespace, caCertData, credentials, skipTlsVerify, 5, 15);
    }

    public KubernetesFactoryAdapter(String serviceAddress, String namespace, @CheckForNull String caCertData, @CheckForNull String credentials, boolean skipTlsVerify, int connectTimeout, int readTimeout) {
        this(serviceAddress, namespace, caCertData, credentials, skipTlsVerify, connectTimeout, readTimeout, 32);
    }

    public KubernetesFactoryAdapter(String serviceAddress, String namespace, @CheckForNull String caCertData, @CheckForNull String credentials, boolean skipTlsVerify, int connectTimeout, int readTimeout, int maxRequestsPerHost) {
        this.serviceAddress = serviceAddress;
        this.namespace = namespace;
        this.caCertData = caCertData;
        this.credentials = credentials != null ? this.getCredentials(credentials) : null;
        this.skipTlsVerify = skipTlsVerify;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.maxRequestsPerHost = maxRequestsPerHost;
    }

    private StandardCredentials getCredentials(String credentials) {
        return (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentials));
    }

    public KubernetesClient createClient() throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, IOException, CertificateEncodingException {
        ConfigBuilder builder;
        if (this.credentials instanceof FileCredentials) {
            LOGGER.log(Level.FINE, "Configuring Kubernetes client from kubeconfig file");
            try (InputStream is = ((FileCredentials)this.credentials).getContent();){
                Config config = Config.fromKubeconfig((String)IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
                builder = new ConfigBuilder(config);
            }
        } else if (StringUtils.isBlank((String)this.serviceAddress)) {
            LOGGER.log(Level.FINE, "Autoconfiguring Kubernetes client");
            builder = new ConfigBuilder(Config.autoConfigure(null));
        } else {
            builder = (ConfigBuilder)new ConfigBuilder().withMasterUrl(this.serviceAddress);
        }
        if (!(this.credentials instanceof FileCredentials)) {
            String token;
            if (this.credentials instanceof StringCredentials) {
                token = ((StringCredentials)this.credentials).getSecret().getPlainText();
                builder.withOauthToken(token);
            } else if (this.credentials instanceof TokenProducer) {
                token = ((TokenProducer)this.credentials).getToken(this.serviceAddress, this.caCertData, this.skipTlsVerify);
                builder.withOauthToken(token);
            } else if (this.credentials instanceof UsernamePasswordCredentials) {
                UsernamePasswordCredentials usernamePassword = (UsernamePasswordCredentials)this.credentials;
                ((ConfigBuilder)builder.withUsername(usernamePassword.getUsername())).withPassword(Secret.toString((Secret)usernamePassword.getPassword()));
            } else if (this.credentials instanceof StandardCertificateCredentials) {
                StandardCertificateCredentials certificateCredentials = (StandardCertificateCredentials)this.credentials;
                KeyStore keyStore = certificateCredentials.getKeyStore();
                String alias = keyStore.aliases().nextElement();
                X509Certificate certificate = (X509Certificate)keyStore.getCertificate(alias);
                Key key = keyStore.getKey(alias, Secret.toString((Secret)certificateCredentials.getPassword()).toCharArray());
                ((ConfigBuilder)((ConfigBuilder)builder.withClientCertData(Base64.encodeBase64String((byte[])certificate.getEncoded()))).withClientKeyData(KubernetesFactoryAdapter.pemEncodeKey(key))).withClientKeyPassphrase(Secret.toString((Secret)certificateCredentials.getPassword()));
            }
        }
        if (this.skipTlsVerify) {
            builder.withTrustCerts(true);
        }
        if (this.caCertData != null) {
            builder.withCaCertData(Base64.encodeBase64String((byte[])this.caCertData.getBytes(StandardCharsets.UTF_8)));
        }
        builder = (ConfigBuilder)((ConfigBuilder)builder.withRequestTimeout(this.readTimeout * 1000)).withConnectionTimeout(this.connectTimeout * 1000);
        builder.withMaxConcurrentRequestsPerHost(this.maxRequestsPerHost);
        if (!StringUtils.isBlank((String)this.namespace)) {
            builder.withNamespace(this.namespace);
        } else if (StringUtils.isBlank((String)builder.getNamespace())) {
            builder.withNamespace("default");
        }
        LOGGER.log(Level.FINE, "Creating Kubernetes client: {0}", this.toString());
        return new DefaultKubernetesClient(builder.build());
    }

    private static String pemEncodeKey(Key key) {
        return Base64.encodeBase64String((byte[])("-----BEGIN PRIVATE KEY-----\n" + Base64.encodeBase64String((byte[])key.getEncoded()) + "\n-----END PRIVATE KEY-----\n").getBytes(StandardCharsets.UTF_8));
    }

    public String toString() {
        return "KubernetesFactoryAdapter [serviceAddress=" + this.serviceAddress + ", namespace=" + this.namespace + ", caCertData=" + this.caCertData + ", credentials=" + this.credentials + ", skipTlsVerify=" + this.skipTlsVerify + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + "]";
    }
}

