/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.security.ACL;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import org.acegisecurity.Authentication;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.InProvisioning;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesFactoryAdapter;
import org.csanchez.jenkins.plugins.kubernetes.PlannedNodeBuilderFactory;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateFilter;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateSource;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateUtils;
import org.csanchez.jenkins.plugins.kubernetes.TokenProducer;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.PodTemplateMap;
import org.jenkinsci.plugins.kubernetes.credentials.FileSystemServiceAccountCredential;
import org.jenkinsci.plugins.kubernetes.credentials.OpenShiftBearerTokenCredentialImpl;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.plaincredentials.impl.StringCredentialsImpl;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class KubernetesCloud
extends Cloud {
    public static final int DEFAULT_MAX_REQUESTS_PER_HOST = 32;
    private static final Logger LOGGER = Logger.getLogger(KubernetesCloud.class.getName());
    public static final String JNLP_NAME = "jnlp";
    @Deprecated
    public static final Map<String, String> DEFAULT_POD_LABELS = ImmutableMap.of((Object)"jenkins", (Object)"slave");
    private static final int DEFAULT_RETENTION_TIMEOUT_MINUTES = 5;
    private String defaultsProviderTemplate;
    @Nonnull
    private List<PodTemplate> templates = new ArrayList<PodTemplate>();
    private String serverUrl;
    @CheckForNull
    private String serverCertificate;
    private boolean skipTlsVerify;
    private boolean addMasterProxyEnvVars;
    private boolean capOnlyOnAlivePods;
    private String namespace;
    private String jenkinsUrl;
    @CheckForNull
    private String jenkinsTunnel;
    @CheckForNull
    private String credentialsId;
    private int containerCap = Integer.MAX_VALUE;
    private int retentionTimeout = 5;
    private int connectTimeout;
    private int readTimeout;
    private Map<String, String> labels;
    private transient KubernetesClient client;
    private int maxRequestsPerHost;

    @DataBoundConstructor
    public KubernetesCloud(String name) {
        super(name);
    }

    public KubernetesCloud(@NonNull String name, @NonNull KubernetesCloud source) {
        super(name);
        this.defaultsProviderTemplate = source.defaultsProviderTemplate;
        this.templates.addAll(source.templates);
        this.serverUrl = source.serverUrl;
        this.skipTlsVerify = source.skipTlsVerify;
        this.addMasterProxyEnvVars = source.addMasterProxyEnvVars;
        this.namespace = source.namespace;
        this.jenkinsUrl = source.jenkinsUrl;
        this.jenkinsTunnel = source.jenkinsTunnel;
        this.credentialsId = source.credentialsId;
        this.containerCap = source.containerCap;
        this.retentionTimeout = source.retentionTimeout;
        this.connectTimeout = source.connectTimeout;
    }

    @Deprecated
    public KubernetesCloud(String name, List<? extends PodTemplate> templates, String serverUrl, String namespace, String jenkinsUrl, String containerCapStr, int connectTimeout, int readTimeout, int retentionTimeout) {
        this(name);
        this.setServerUrl(serverUrl);
        this.setNamespace(namespace);
        this.setJenkinsUrl(jenkinsUrl);
        if (templates != null) {
            this.templates.addAll(templates);
        }
        this.setContainerCapStr(containerCapStr);
        this.setRetentionTimeout(retentionTimeout);
        this.setConnectTimeout(connectTimeout);
        this.setReadTimeout(readTimeout);
    }

    public int getRetentionTimeout() {
        return this.retentionTimeout;
    }

    @DataBoundSetter
    public void setRetentionTimeout(int retentionTimeout) {
        this.retentionTimeout = retentionTimeout;
    }

    public String getDefaultsProviderTemplate() {
        return this.defaultsProviderTemplate;
    }

    @DataBoundSetter
    public void setDefaultsProviderTemplate(String defaultsProviderTemplate) {
        this.defaultsProviderTemplate = defaultsProviderTemplate;
    }

    @Nonnull
    public List<PodTemplate> getTemplates() {
        return this.templates;
    }

    @Nonnull
    public List<PodTemplate> getAllTemplates() {
        return PodTemplateSource.getAll(this);
    }

    @DataBoundSetter
    public void setTemplates(@Nonnull List<PodTemplate> templates) {
        this.templates = new ArrayList<PodTemplate>(templates);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    @DataBoundSetter
    public void setServerUrl(@Nonnull String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getServerCertificate() {
        return this.serverCertificate;
    }

    @DataBoundSetter
    public void setServerCertificate(String serverCertificate) {
        this.serverCertificate = Util.fixEmpty((String)serverCertificate);
    }

    public boolean isSkipTlsVerify() {
        return this.skipTlsVerify;
    }

    @DataBoundSetter
    public void setSkipTlsVerify(boolean skipTlsVerify) {
        this.skipTlsVerify = skipTlsVerify;
    }

    public boolean isAddMasterProxyEnvVars() {
        return this.addMasterProxyEnvVars;
    }

    @DataBoundSetter
    public void setAddMasterProxyEnvVars(boolean addMasterProxyEnvVars) {
        this.addMasterProxyEnvVars = addMasterProxyEnvVars;
    }

    @Nonnull
    public String getNamespace() {
        return this.namespace;
    }

    @DataBoundSetter
    public void setNamespace(@Nonnull String namespace) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)namespace) ? 1 : 0) != 0);
        this.namespace = namespace;
    }

    @CheckForNull
    public String getJenkinsUrl() {
        return this.jenkinsUrl;
    }

    @DataBoundSetter
    public void setCapOnlyOnAlivePods(boolean capOnlyOnAlivePods) {
        this.capOnlyOnAlivePods = capOnlyOnAlivePods;
    }

    public boolean isCapOnlyOnAlivePods() {
        return this.capOnlyOnAlivePods;
    }

    @Nonnull
    public String getJenkinsUrlOrDie() {
        JenkinsLocationConfiguration locationConfiguration = JenkinsLocationConfiguration.get();
        String locationConfigurationUrl = locationConfiguration != null ? locationConfiguration.getUrl() : null;
        String url = StringUtils.defaultIfBlank((String)this.getJenkinsUrl(), (String)StringUtils.defaultIfBlank((String)System.getProperty("KUBERNETES_JENKINS_URL", System.getenv("KUBERNETES_JENKINS_URL")), (String)locationConfigurationUrl));
        if (url == null) {
            throw new IllegalStateException("Jenkins URL for Kubernetes is null");
        }
        url = url.endsWith("/") ? url : url + "/";
        return url;
    }

    @DataBoundSetter
    public void setJenkinsUrl(String jenkinsUrl) {
        this.jenkinsUrl = Util.fixEmptyAndTrim((String)jenkinsUrl);
    }

    public String getJenkinsTunnel() {
        return this.jenkinsTunnel;
    }

    @DataBoundSetter
    public void setJenkinsTunnel(String jenkinsTunnel) {
        this.jenkinsTunnel = Util.fixEmpty((String)jenkinsTunnel);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    public int getContainerCap() {
        return this.containerCap;
    }

    @DataBoundSetter
    public void setContainerCapStr(String containerCapStr) {
        this.containerCap = containerCapStr.equals("") ? Integer.MAX_VALUE : Integer.parseInt(containerCapStr);
    }

    public String getContainerCapStr() {
        if (this.containerCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.containerCap);
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public Map<String, String> getLabels() {
        return this.labels == null || this.labels.isEmpty() ? DEFAULT_POD_LABELS : this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    @DataBoundSetter
    public void setMaxRequestsPerHostStr(String maxRequestsPerHostStr) {
        try {
            this.maxRequestsPerHost = Integer.parseInt(maxRequestsPerHostStr);
        }
        catch (NumberFormatException e) {
            this.maxRequestsPerHost = 32;
        }
    }

    public String getMaxRequestsPerHostStr() {
        return String.valueOf(this.maxRequestsPerHost);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC", "DC_DOUBLECHECK"})
    public KubernetesClient connect() throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, IOException, CertificateEncodingException {
        LOGGER.log(Level.FINE, "Building connection to Kubernetes {0} URL {1} namespace {2}", new String[]{this.getDisplayName(), this.serverUrl, this.namespace});
        this.client = new KubernetesFactoryAdapter(this.serverUrl, this.namespace, this.serverCertificate, this.credentialsId, this.skipTlsVerify, this.connectTimeout, this.readTimeout, this.maxRequestsPerHost).createClient();
        LOGGER.log(Level.FINE, "Connected to Kubernetes {0} URL {1}", new String[]{this.getDisplayName(), this.serverUrl});
        return this.client;
    }

    public synchronized Collection<NodeProvisioner.PlannedNode> provision(@CheckForNull Label label, int excessWorkload) {
        try {
            Set<String> allInProvisioning = InProvisioning.getAllInProvisioning(label);
            LOGGER.log(Level.FINE, () -> "In provisioning : " + allInProvisioning);
            int toBeProvisioned = Math.max(0, excessWorkload - allInProvisioning.size());
            LOGGER.log(Level.INFO, "Excess workload after pending Kubernetes agents: " + toBeProvisioned);
            ArrayList<NodeProvisioner.PlannedNode> r = new ArrayList<NodeProvisioner.PlannedNode>();
            for (PodTemplate t : this.getTemplatesFor(label)) {
                LOGGER.log(Level.INFO, "Template: " + t.getDisplayName());
                for (int i = 1; i <= toBeProvisioned && this.addProvisionedSlave(t, label); ++i) {
                    r.add(PlannedNodeBuilderFactory.createInstance().cloud(this).template(t).label(label).build());
                }
                if (r.size() <= 0) continue;
                return r;
            }
            return r;
        }
        catch (KubernetesClientException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SocketTimeoutException || cause instanceof ConnectException || cause instanceof UnknownHostException) {
                LOGGER.log(Level.WARNING, "Failed to connect to Kubernetes at {0}: {1}", new String[]{this.serverUrl, cause.getMessage()});
            } else {
                LOGGER.log(Level.WARNING, "Failed to count the # of live instances on Kubernetes", cause != null ? cause : e);
            }
        }
        catch (ConnectException e) {
            LOGGER.log(Level.WARNING, "Failed to connect to Kubernetes at {0}", this.serverUrl);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to count the # of live instances on Kubernetes", e);
        }
        return Collections.emptyList();
    }

    private boolean addProvisionedSlave(@Nonnull PodTemplate template, @CheckForNull Label label) throws Exception {
        if (this.containerCap == 0) {
            return true;
        }
        KubernetesClient client = this.connect();
        String templateNamespace = template.getNamespace();
        if (Strings.isNullOrEmpty((String)templateNamespace)) {
            templateNamespace = client.getNamespace();
        }
        PodList slaveList = (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(templateNamespace)).withLabels(this.getLabels())).list();
        List slaveListItems = slaveList.getItems();
        HashMap<String, String> labelsMap = new HashMap<String, String>(this.getLabels());
        labelsMap.putAll(template.getLabelsMap());
        PodList namedList = (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(templateNamespace)).withLabels(labelsMap)).list();
        List namedListItems = namedList.getItems();
        if (this.isCapOnlyOnAlivePods()) {
            slaveListItems = slaveListItems.stream().filter(x -> x.getStatus().getPhase().toLowerCase().matches("(running|pending)")).collect(Collectors.toList());
        }
        if (template.isCapOnlyOnAlivePods()) {
            namedListItems = namedListItems.stream().filter(x -> x.getStatus().getPhase().toLowerCase().matches("(running|pending)")).collect(Collectors.toList());
        }
        if (slaveListItems != null && this.containerCap <= slaveListItems.size()) {
            LOGGER.log(Level.INFO, "Total container cap of {0} reached, not provisioning: {1} running or errored in namespace {2} with Kubernetes labels {3}", new Object[]{this.containerCap, slaveListItems.size(), templateNamespace, this.getLabels()});
            return false;
        }
        if (namedListItems != null && slaveListItems != null && template.getInstanceCap() <= namedListItems.size()) {
            LOGGER.log(Level.INFO, "Template instance cap of {0} reached for template {1}, not provisioning: {2} running or errored in namespace {3} with label \"{4}\" and Kubernetes labels {5}", new Object[]{template.getInstanceCap(), template.getName(), slaveListItems.size(), templateNamespace, label == null ? "" : label.toString(), labelsMap});
            return false;
        }
        return true;
    }

    public boolean canProvision(@CheckForNull Label label) {
        return this.getTemplate(label) != null;
    }

    public PodTemplate getTemplate(@CheckForNull Label label) {
        return PodTemplateUtils.getTemplateByLabel(label, this.getAllTemplates());
    }

    public PodTemplate getUnwrappedTemplate(PodTemplate podTemplate) {
        return PodTemplateUtils.unwrap(podTemplate, this.getDefaultsProviderTemplate(), this.getAllTemplates());
    }

    @Deprecated
    public ArrayList<PodTemplate> getMatchingTemplates(@CheckForNull Label label) {
        return new ArrayList<PodTemplate>(this.getTemplatesFor(label));
    }

    public List<PodTemplate> getTemplatesFor(@CheckForNull Label label) {
        return PodTemplateFilter.applyAll(this, this.getAllTemplates(), label);
    }

    public void addTemplate(PodTemplate t) {
        this.templates.add(t);
    }

    public void removeTemplate(PodTemplate t) {
        this.templates.remove(t);
    }

    public void addDynamicTemplate(PodTemplate t) {
        PodTemplateMap.get().addTemplate(this, t);
    }

    public void removeDynamicTemplate(PodTemplate t) {
        PodTemplateMap.get().removeTemplate(this, t);
    }

    public String toString() {
        return String.format("KubernetesCloud name: %s serverUrl: %s", this.name, this.serverUrl);
    }

    private Object readResolve() {
        if (this.serverCertificate != null && !this.serverCertificate.trim().startsWith("-----BEGIN CERTIFICATE-----")) {
            this.serverCertificate = new String(Base64.decodeBase64((byte[])this.serverCertificate.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            LOGGER.log(Level.INFO, "Upgraded Kubernetes server certificate key: {0}", this.serverCertificate.substring(0, 80));
        }
        if (this.maxRequestsPerHost == 0) {
            this.maxRequestsPerHost = 32;
        }
        return this;
    }

    @Extension
    public static class PodTemplateSourceImpl
    extends PodTemplateSource {
        @Override
        @Nonnull
        public List<PodTemplate> getList(@Nonnull KubernetesCloud cloud) {
            return cloud.getTemplates();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        public String getDisplayName() {
            return "Kubernetes";
        }

        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void addAliases() {
            Jenkins.XSTREAM2.addCompatibilityAlias("org.csanchez.jenkins.plugins.kubernetes.OpenShiftBearerTokenCredentialImpl", OpenShiftBearerTokenCredentialImpl.class);
            Jenkins.XSTREAM2.addCompatibilityAlias("org.csanchez.jenkins.plugins.kubernetes.OpenShiftTokenCredentialImpl", StringCredentialsImpl.class);
            Jenkins.XSTREAM2.addCompatibilityAlias("org.csanchez.jenkins.plugins.kubernetes.ServiceAccountCredential", FileSystemServiceAccountCredential.class);
        }

        public FormValidation doTestConnection(@QueryParameter String name, @QueryParameter String serverUrl, @QueryParameter String credentialsId, @QueryParameter String serverCertificate, @QueryParameter boolean skipTlsVerify, @QueryParameter String namespace, @QueryParameter int connectionTimeout, @QueryParameter int readTimeout) throws Exception {
            if (StringUtils.isBlank((String)name)) {
                return FormValidation.error((String)"name is required");
            }
            try {
                KubernetesClient client = new KubernetesFactoryAdapter(serverUrl, namespace, Util.fixEmpty((String)serverCertificate), Util.fixEmpty((String)credentialsId), skipTlsVerify, connectionTimeout, readTimeout).createClient();
                client.pods().list();
                return FormValidation.ok((String)"Connection test successful");
            }
            catch (KubernetesClientException e) {
                LOGGER.log(Level.FINE, String.format("Error testing connection %s", serverUrl), e);
                return FormValidation.error((String)"Error testing connection %s: %s", (Object[])new Object[]{serverUrl, e.getCause() == null ? e.getMessage() : String.format("%s: %s", e.getCause().getClass().getName(), e.getCause().getMessage())});
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, String.format("Error testing connection %s", serverUrl), e);
                return FormValidation.error((String)"Error testing connection %s: %s", (Object[])new Object[]{serverUrl, e.getMessage()});
            }
        }

        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String serverUrl) {
            return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(FileCredentials.class), CredentialsMatchers.instanceOf(TokenProducer.class), CredentialsMatchers.instanceOf(org.jenkinsci.plugins.kubernetes.credentials.TokenProducer.class), CredentialsMatchers.instanceOf(StandardCertificateCredentials.class), CredentialsMatchers.instanceOf(StringCredentials.class)}), (Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (List)(serverUrl != null ? URIRequirementBuilder.fromUri((String)serverUrl).build() : Collections.EMPTY_LIST)));
        }

        public FormValidation doCheckMaxRequestsPerHostStr(@QueryParameter String value) throws IOException, ServletException {
            try {
                Integer.parseInt(value);
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Please supply an integer");
            }
        }
    }
}

