/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildWrapper;
import org.acegisecurity.Authentication;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.kubernetes.credentials.TokenProducer;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class KubectlBuildWrapper
extends SimpleBuildWrapper {
    private static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    private static final String BEGIN_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----";
    private static final String END_PRIVATE_KEY = "-----END PRIVATE KEY-----";
    private final String serverUrl;
    private final String credentialsId;
    private final String caCertificate;

    @DataBoundConstructor
    public KubectlBuildWrapper(@Nonnull String serverUrl, @Nonnull String credentialsId, @Nonnull String caCertificate) {
        this.serverUrl = serverUrl;
        this.credentialsId = credentialsId;
        this.caCertificate = caCertificate;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getCaCertificate() {
        return this.caCertificate;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        String login;
        String tlsConfig;
        FilePath configFile = workspace.createTempFile(".kube", "config");
        HashSet tempFiles = Sets.newHashSet((Object[])new String[]{configFile.getRemote()});
        context.env("KUBECONFIG", configFile.getRemote());
        context.setDisposer((SimpleBuildWrapper.Disposer)new CleanupDisposer(tempFiles));
        if (this.caCertificate != null && !this.caCertificate.isEmpty()) {
            FilePath caCrtFile = workspace.createTempFile("cert-auth", "crt");
            String ca = this.caCertificate;
            if (!ca.startsWith(BEGIN_CERTIFICATE)) {
                ca = KubectlBuildWrapper.wrapWithMarker(BEGIN_CERTIFICATE, END_CERTIFICATE, ca);
            }
            caCrtFile.write(ca, null);
            tempFiles.add(caCrtFile.getRemote());
            tlsConfig = " --certificate-authority=" + caCrtFile.getRemote();
        } else {
            tlsConfig = " --insecure-skip-tls-verify=true";
        }
        int status = launcher.launch().cmdAsSingleString("kubectl config --kubeconfig=\"" + configFile.getRemote() + "\" set-cluster k8s --server=" + this.serverUrl + tlsConfig).join();
        if (status != 0) {
            throw new IOException("Failed to run kubectl config " + status);
        }
        StandardCredentials c = this.getCredentials();
        if (c == null) {
            throw new AbortException("No credentials defined to setup Kubernetes CLI");
        }
        if (c instanceof FileCredentials) {
            try (InputStream in = ((FileCredentials)c).getContent();
                 OutputStream out = configFile.write();){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            return;
        }
        if (c instanceof StringCredentials) {
            login = "--token=" + ((StringCredentials)c).getSecret().getPlainText();
        } else if (c instanceof TokenProducer) {
            login = "--token=" + ((TokenProducer)c).getToken(this.serverUrl, null, true);
        } else if (c instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials upc = (UsernamePasswordCredentials)c;
            login = "--username=" + upc.getUsername() + " --password=" + Secret.toString((Secret)upc.getPassword());
        } else if (c instanceof StandardCertificateCredentials) {
            StandardCertificateCredentials scc = (StandardCertificateCredentials)c;
            KeyStore keyStore = scc.getKeyStore();
            try {
                String alias = keyStore.aliases().nextElement();
                X509Certificate certificate = (X509Certificate)keyStore.getCertificate(alias);
                Key key = keyStore.getKey(alias, Secret.toString((Secret)scc.getPassword()).toCharArray());
                FilePath clientCrtFile = workspace.createTempFile("client", "crt");
                FilePath clientKeyFile = workspace.createTempFile("client", "key");
                String encodedClientCrt = KubectlBuildWrapper.wrapWithMarker(BEGIN_CERTIFICATE, END_CERTIFICATE, Base64.encodeBase64String((byte[])certificate.getEncoded()));
                String encodedClientKey = KubectlBuildWrapper.wrapWithMarker(BEGIN_PRIVATE_KEY, END_PRIVATE_KEY, Base64.encodeBase64String((byte[])key.getEncoded()));
                clientCrtFile.write(encodedClientCrt, null);
                clientKeyFile.write(encodedClientKey, null);
                tempFiles.add(clientCrtFile.getRemote());
                tempFiles.add(clientKeyFile.getRemote());
                login = "--client-certificate=" + clientCrtFile.getRemote() + " --client-key=" + clientKeyFile.getRemote();
            }
            catch (KeyStoreException e) {
                throw new AbortException(e.getMessage());
            }
            catch (UnrecoverableKeyException e) {
                throw new AbortException(e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                throw new AbortException(e.getMessage());
            }
            catch (CertificateEncodingException e) {
                throw new AbortException(e.getMessage());
            }
        } else {
            throw new AbortException("Unsupported Credentials type " + c.getClass().getName());
        }
        status = launcher.launch().cmdAsSingleString("kubectl config --kubeconfig=\"" + configFile.getRemote() + "\" set-credentials cluster-admin " + login).masks(new boolean[]{false, false, false, false, false, false, true}).join();
        if (status != 0) {
            throw new IOException("Failed to run kubectl config " + status);
        }
        status = launcher.launch().cmdAsSingleString("kubectl config --kubeconfig=\"" + configFile.getRemote() + "\" set-context k8s --cluster=k8s --user=cluster-admin").join();
        if (status != 0) {
            throw new IOException("Failed to run kubectl config " + status);
        }
        status = launcher.launch().cmdAsSingleString("kubectl config --kubeconfig=\"" + configFile.getRemote() + "\" use-context k8s").join();
        if (status != 0) {
            throw new IOException("Failed to run kubectl config " + status);
        }
    }

    @CheckForNull
    private StandardCredentials getCredentials() throws AbortException {
        if (StringUtils.isBlank((String)this.credentialsId)) {
            return null;
        }
        StandardCredentials result = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)this.credentialsId));
        if (result == null) {
            throw new AbortException("No credentials found for id \"" + this.credentialsId + "\"");
        }
        return result;
    }

    private static String wrapWithMarker(String begin, String end, String encodedBody) {
        return begin + "\n" + encodedBody + "\n" + end;
    }

    private static class CleanupDisposer
    extends SimpleBuildWrapper.Disposer {
        private static final long serialVersionUID = 3006113419319201358L;
        private Set<String> configFiles;

        public CleanupDisposer(Set<String> tempFiles) {
            this.configFiles = tempFiles;
        }

        public void tearDown(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
            for (String configFile : this.configFiles) {
                workspace.child(configFile).delete();
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "Setup Kubernetes CLI (kubectl)";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String serverUrl) {
            return new StandardListBoxModel().withEmptySelection().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(TokenProducer.class), CredentialsMatchers.instanceOf(StandardCertificateCredentials.class), CredentialsMatchers.instanceOf(FileCredentials.class)}), (Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)item, null, (List)URIRequirementBuilder.fromUri((String)serverUrl).build()));
        }
    }
}

