/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.volumes.workspace;

import hudson.Extension;
import hudson.model.Descriptor;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.csanchez.jenkins.plugins.kubernetes.volumes.workspace.WorkspaceVolume;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class EmptyDirWorkspaceVolume
extends WorkspaceVolume {
    private static final String DEFAULT_MEDIUM = "";
    private static final String MEMORY_MEDIUM = "Memory";
    @CheckForNull
    private Boolean memory;

    @DataBoundConstructor
    public EmptyDirWorkspaceVolume(Boolean memory) {
        this.memory = memory;
    }

    public String getMedium() {
        return this.getMemory() != false ? MEMORY_MEDIUM : DEFAULT_MEDIUM;
    }

    @Nonnull
    public Boolean getMemory() {
        return this.memory != null && this.memory != false;
    }

    @Override
    public Volume buildVolume(String volumeName, String podName) {
        return ((VolumeBuilder)((VolumeFluent.EmptyDirNested)((VolumeBuilder)new VolumeBuilder().withName(volumeName)).withNewEmptyDir().withMedium(this.getMedium())).endEmptyDir()).build();
    }

    public String toString() {
        return "EmptyDirWorkspaceVolume [memory=" + this.memory + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmptyDirWorkspaceVolume that = (EmptyDirWorkspaceVolume)o;
        return Objects.equals(this.memory, that.memory);
    }

    public int hashCode() {
        return Objects.hash(this.memory);
    }

    @Extension
    @Symbol(value={"emptyDirWorkspaceVolume"})
    public static class DescriptorImpl
    extends Descriptor<WorkspaceVolume> {
        public String getDisplayName() {
            return "Empty Dir Workspace Volume";
        }
    }
}

