/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.volumes.workspace;

import com.google.common.collect.ImmutableMap;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplateUtils;
import org.csanchez.jenkins.plugins.kubernetes.volumes.workspace.WorkspaceVolume;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class DynamicPVCWorkspaceVolume
extends WorkspaceVolume {
    private String storageClassName;
    private String requestsSize;
    private String accessModes;
    private static final Logger LOGGER = Logger.getLogger(DynamicPVCWorkspaceVolume.class.getName());

    @DataBoundConstructor
    public DynamicPVCWorkspaceVolume() {
    }

    public DynamicPVCWorkspaceVolume(String storageClassName, String requestsSize, String accessModes) {
        this.storageClassName = storageClassName;
        this.requestsSize = requestsSize;
        this.accessModes = accessModes;
    }

    @CheckForNull
    public String getAccessModes() {
        return this.accessModes;
    }

    @DataBoundSetter
    public void setAccessModes(@CheckForNull String accessModes) {
        this.accessModes = Util.fixEmpty((String)accessModes);
    }

    @CheckForNull
    public String getRequestsSize() {
        return this.requestsSize;
    }

    @DataBoundSetter
    public void setRequestsSize(@CheckForNull String requestsSize) {
        this.requestsSize = Util.fixEmpty((String)requestsSize);
    }

    @CheckForNull
    public String getStorageClassName() {
        return this.storageClassName;
    }

    @DataBoundSetter
    public void setStorageClassName(@CheckForNull String storageClassName) {
        this.storageClassName = Util.fixEmpty((String)storageClassName);
    }

    @Override
    public Volume buildVolume(String volumeName, String podName) {
        return ((VolumeBuilder)((VolumeFluent.PersistentVolumeClaimNested)((VolumeFluent.PersistentVolumeClaimNested)((VolumeBuilder)new VolumeBuilder().withName(volumeName)).withNewPersistentVolumeClaim().withClaimName("pvc-" + podName)).withReadOnly(Boolean.valueOf(false))).and()).build();
    }

    @Override
    public PersistentVolumeClaim createVolume(KubernetesClient client, ObjectMeta podMetaData) {
        String namespace = podMetaData.getNamespace();
        String podId = podMetaData.getName();
        LOGGER.log(Level.FINE, "Adding workspace volume from pod: {0}/{1}", new Object[]{namespace, podId});
        OwnerReference ownerReference = ((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)((OwnerReferenceBuilder)new OwnerReferenceBuilder().withApiVersion("v1")).withKind("Pod")).withBlockOwnerDeletion(Boolean.valueOf(true))).withController(Boolean.valueOf(true))).withName(podMetaData.getName())).withUid(podMetaData.getUid())).build();
        PersistentVolumeClaim pvc = ((PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimSpecFluent.ResourcesNested)((PersistentVolumeClaimFluent.SpecNested)((PersistentVolumeClaimBuilder)((PersistentVolumeClaimFluent.MetadataNested)((PersistentVolumeClaimFluent.MetadataNested)((PersistentVolumeClaimFluent.MetadataNested)new PersistentVolumeClaimBuilder().withNewMetadata().withName("pvc-" + podMetaData.getName())).withOwnerReferences(new OwnerReference[]{ownerReference})).withLabels(KubernetesCloud.DEFAULT_POD_LABELS)).endMetadata()).withNewSpec().withAccessModes(new String[]{this.getAccessModesOrDefault()})).withNewResources().withRequests(this.getResourceMap())).endResources()).withStorageClassName(this.getStorageClassNameOrDefault())).endSpec()).build();
        pvc = (PersistentVolumeClaim)((NonNamespaceOperation)client.persistentVolumeClaims().inNamespace(podMetaData.getNamespace())).create((Object)pvc);
        LOGGER.log(Level.INFO, "Created PVC: {0}/{1}", new Object[]{namespace, pvc.getMetadata().getName()});
        return pvc;
    }

    public String getStorageClassNameOrDefault() {
        if (this.getStorageClassName() != null) {
            return this.getStorageClassName();
        }
        return null;
    }

    public String getAccessModesOrDefault() {
        if (this.getAccessModes() != null) {
            return this.getAccessModes();
        }
        return "ReadWriteOnce";
    }

    public String getRequestsSizeOrDefault() {
        if (this.getRequestsSize() != null) {
            return this.getRequestsSize();
        }
        return "10Gi";
    }

    protected Map<String, Quantity> getResourceMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String actualStorage = PodTemplateUtils.substituteEnv(this.getRequestsSizeOrDefault());
        Quantity storageQuantity = new Quantity(actualStorage);
        builder.put((Object)"storage", (Object)storageQuantity);
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicPVCWorkspaceVolume that = (DynamicPVCWorkspaceVolume)o;
        return Objects.equals(this.storageClassName, that.storageClassName) && Objects.equals(this.requestsSize, that.requestsSize) && Objects.equals(this.accessModes, that.accessModes);
    }

    public int hashCode() {
        return Objects.hash(this.storageClassName, this.requestsSize, this.accessModes);
    }

    @Extension
    @Symbol(value={"dynamicPVC"})
    public static class DescriptorImpl
    extends Descriptor<WorkspaceVolume> {
        private static final ListBoxModel ACCESS_MODES_BOX = new ListBoxModel().add("ReadWriteOnce").add("ReadOnlyMany").add("ReadWriteMany");

        public String getDisplayName() {
            return "Dynamic Persistent Volume Claim Workspace Volume";
        }

        @RequirePOST
        @Restricted(value={DoNotUse.class})
        public ListBoxModel doFillAccessModesItems() {
            return ACCESS_MODES_BOX;
        }
    }
}

