/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pod.retention;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerListener;
import io.fabric8.kubernetes.api.model.ContainerStateTerminated;
import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesComputer;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.PodUtils;

@Extension
public class Reaper
extends ComputerListener
implements Watcher<Pod> {
    private static final Logger LOGGER = Logger.getLogger(Reaper.class.getName());
    private final AtomicBoolean activated = new AtomicBoolean();
    private Watch watch;

    public static Reaper getInstance() {
        return (Reaper)((Object)ExtensionList.lookupSingleton(Reaper.class));
    }

    public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
        if (c instanceof KubernetesComputer && this.activated.compareAndSet(false, true)) {
            this.activate();
        }
    }

    private void activate() {
        LOGGER.fine("Activating reaper");
        for (Node n : new ArrayList(Jenkins.get().getNodes())) {
            if (!(n instanceof KubernetesSlave)) continue;
            KubernetesSlave ks = (KubernetesSlave)n;
            String ns = ks.getNamespace();
            String name = ks.getPodName();
            try {
                if (((PodResource)((NonNamespaceOperation)ks.getKubernetesCloud().connect().pods().inNamespace(ns)).withName(name)).get() == null) {
                    LOGGER.info(() -> ns + "/" + name + " seems to have been deleted, so removing corresponding Jenkins agent");
                    Jenkins.get().removeNode((Node)ks);
                    continue;
                }
                LOGGER.fine(() -> ns + "/" + name + " still seems to exist, OK");
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, "failed to do initial reap check for " + ns + "/" + name, x);
            }
        }
        for (Cloud c : Jenkins.get().clouds) {
            if (!(c instanceof KubernetesCloud)) continue;
            KubernetesCloud kc = (KubernetesCloud)c;
            try {
                KubernetesClient client = kc.connect();
                this.watch = (Watch)((NonNamespaceOperation)client.pods().inNamespace(client.getNamespace())).watch((Object)this);
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, "failed to set up watcher on " + kc.getDisplayName(), x);
            }
        }
    }

    public void eventReceived(Watcher.Action action, Pod pod) {
        String ns = pod.getMetadata().getNamespace();
        String name = pod.getMetadata().getName();
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return;
        }
        Optional<KubernetesSlave> optionalNode = Reaper.resolveNode(jenkins, ns, name);
        if (!optionalNode.isPresent()) {
            return;
        }
        ExtensionList.lookup(Listener.class).forEach(listener -> {
            try {
                listener.onEvent(action, (KubernetesSlave)((Object)((Object)optionalNode.get())), pod);
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, "Listener " + listener + " failed for " + ns + "/" + name, x);
            }
        });
    }

    private static Optional<KubernetesSlave> resolveNode(@NonNull Jenkins jenkins, String namespace, String name) {
        return new ArrayList(jenkins.getNodes()).stream().filter(KubernetesSlave.class::isInstance).map(KubernetesSlave.class::cast).filter(ks -> Objects.equals(ks.getNamespace(), namespace) && Objects.equals(ks.getPodName(), name)).findFirst();
    }

    public void onClose(KubernetesClientException cause) {
    }

    private void closeWatch() {
        if (this.watch != null) {
            this.watch.close();
        }
    }

    @Extension
    public static class TerminateAgentOnImagePullBackOff
    implements Listener {
        @Override
        public void onEvent(@NonNull Watcher.Action action, @NonNull KubernetesSlave node, @NonNull Pod pod) throws IOException, InterruptedException {
            List<ContainerStatus> backOffContainers = PodUtils.getContainers(pod, cs -> {
                ContainerStateWaiting waiting = cs.getState().getWaiting();
                return waiting != null && waiting.getMessage() != null && waiting.getMessage().contains("Back-off pulling image");
            });
            if (backOffContainers.isEmpty()) {
                return;
            }
            backOffContainers.forEach(cs -> {
                TaskListener runListener = node.getTemplate().getListener();
                runListener.error("Unable to pull Docker image \"" + cs.getImage() + "\". Check if image tag name is spelled correctly.");
            });
            try (ACLContext _ = ACL.as((Authentication)ACL.SYSTEM);){
                PodUtils.cancelQueueItemFor(pod, "ImagePullBackOff");
            }
            node.terminate();
        }
    }

    @Extension
    public static class TerminateAgentOnPodFailed
    implements Listener {
        @Override
        public void onEvent(@NonNull Watcher.Action action, @NonNull KubernetesSlave node, @NonNull Pod pod) throws IOException, InterruptedException {
            if (action != Watcher.Action.MODIFIED) {
                return;
            }
            if ("Failed".equals(pod.getStatus().getPhase())) {
                String ns = pod.getMetadata().getNamespace();
                String name = pod.getMetadata().getName();
                TaskListener runListener = node.getTemplate().getListener();
                LOGGER.info(() -> ns + "/" + name + " Pod just failed. Removing the corresponding Jenkins agent. Reason: " + pod.getStatus().getReason() + ", Message: " + pod.getStatus().getMessage());
                runListener.getLogger().printf("%s/%s Pod just failed (Reason: %s, Message: %s)%n", ns, name, pod.getStatus().getReason(), pod.getStatus().getMessage());
                node.terminate();
            }
        }
    }

    @Extension
    public static class TerminateAgentOnContainerTerminated
    implements Listener {
        @Override
        public void onEvent(@NonNull Watcher.Action action, @NonNull KubernetesSlave node, @NonNull Pod pod) throws IOException, InterruptedException {
            if (action != Watcher.Action.MODIFIED) {
                return;
            }
            List<ContainerStatus> terminatedContainers = PodUtils.getTerminatedContainers(pod);
            if (!terminatedContainers.isEmpty()) {
                String ns = pod.getMetadata().getNamespace();
                String name = pod.getMetadata().getName();
                TaskListener runListener = node.getTemplate().getListener();
                terminatedContainers.forEach(c -> {
                    ContainerStateTerminated t = c.getState().getTerminated();
                    LOGGER.info(() -> ns + "/" + name + " Container " + c.getName() + " was just terminated, so removing the corresponding Jenkins agent");
                    runListener.getLogger().printf("%s/%s Container %s was terminated (Exit Code: %d, Reason: %s)%n", ns, name, c.getName(), t.getExitCode(), t.getReason());
                });
                node.terminate();
            }
        }
    }

    @Extension
    public static class RemoveAgentOnPodDeleted
    implements Listener {
        @Override
        public void onEvent(@NonNull Watcher.Action action, @NonNull KubernetesSlave node, @NonNull Pod pod) throws IOException {
            if (action != Watcher.Action.DELETED) {
                return;
            }
            String ns = pod.getMetadata().getNamespace();
            String name = pod.getMetadata().getName();
            TaskListener runListener = node.getTemplate().getListener();
            LOGGER.info(() -> ns + "/" + name + " was just deleted, so removing corresponding Jenkins agent");
            runListener.getLogger().printf("Pod %s/%s was just deleted%n", ns, name);
            Jenkins.get().removeNode((Node)node);
        }
    }

    public static interface Listener
    extends ExtensionPoint {
        public void onEvent(@NonNull Watcher.Action var1, @NonNull KubernetesSlave var2, @NonNull Pod var3) throws IOException, InterruptedException;
    }

    @Extension
    public static class ReaperShutdownListener
    extends ItemListener {
        public void onBeforeShutdown() {
            Reaper.getInstance().closeWatch();
        }
    }
}

