/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pod.retention;

import hudson.Extension;
import io.fabric8.kubernetes.api.model.Pod;
import java.io.Serializable;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.Messages;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.PodRetention;
import org.csanchez.jenkins.plugins.kubernetes.pod.retention.PodRetentionDescriptor;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class OnFailure
extends PodRetention
implements Serializable {
    private static final long serialVersionUID = 6424267627207206819L;

    @DataBoundConstructor
    public OnFailure() {
    }

    @Override
    public boolean shouldDeletePod(KubernetesCloud cloud, Pod pod) {
        if (pod == null || pod.getStatus() == null) {
            return false;
        }
        boolean hasErrors = pod.getStatus().getPhase().toLowerCase().matches("(failed|unknown)");
        return !hasErrors;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj instanceof OnFailure;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Extension
    @Symbol(value={"onFailure"})
    public static class DescriptorImpl
    extends PodRetentionDescriptor {
        public String getDisplayName() {
            return Messages.on_Failure();
        }
    }
}

