/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import hudson.model.TaskListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class Resources {
    private static final transient Logger LOGGER = Logger.getLogger(ContainerStepExecution.class.getName());

    static void closeQuietly(StepContext context, Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (IOException e) {
                try {
                    ((TaskListener)context.get(TaskListener.class)).error("Error while closing: [" + c + "]");
                }
                catch (IOException | InterruptedException e1) {
                    LOGGER.log(Level.WARNING, "Error writing to task listener", e);
                }
            }
        }
    }
}

