/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import hudson.Extension;
import hudson.ExtensionComponent;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import jenkins.ExtensionFilter;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.workflow.cps.GroovySample;

public class KubernetesSamples {
    private KubernetesSamples() {
    }

    @Extension(ordinal=1300.0, optional=true)
    public static final class Windows
    extends Static {
        public String name() {
            return "kubernetes-windows";
        }

        public String title() {
            return "Windows (Kubernetes)";
        }
    }

    @Extension(ordinal=1400.0, optional=true)
    public static final class Maven
    extends Static {
        public String name() {
            return "kubernetes-maven";
        }

        public String title() {
            return "Maven (Kubernetes)";
        }
    }

    @Extension(ordinal=1500.0, optional=true)
    public static final class Declarative
    extends Static {
        public String name() {
            return "kubernetes-declarative";
        }

        public String title() {
            return "Declarative (Kubernetes)";
        }
    }

    private static abstract class Static
    implements GroovySample {
        private Static() {
        }

        public String script() {
            try {
                return IOUtils.toString((URL)KubernetesSamples.class.getResource("samples/" + this.name().replaceFirst("^kubernetes-", "") + ".groovy"), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException x) {
                throw new AssertionError((Object)x);
            }
        }
    }

    @Extension
    public static final class SuppressToolBasedSamples
    extends ExtensionFilter {
        public <T> boolean allows(Class<T> type, ExtensionComponent<T> component) {
            if (type.getName().equals("org.jenkinsci.plugins.workflow.cps.GroovySample")) {
                switch (((GroovySample)component.getInstance()).name()) {
                    case "github-maven": 
                    case "scripted": {
                        return false;
                    }
                }
            }
            return true;
        }
    }
}

