/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.model;

import hudson.Extension;
import hudson.model.Descriptor;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.SecretKeySelectorBuilder;
import org.csanchez.jenkins.plugins.kubernetes.model.TemplateEnvVar;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class SecretEnvVar
extends TemplateEnvVar {
    private static final long serialVersionUID = -7481523353781581248L;
    private String secretName;
    private String secretKey;
    private Boolean optional;

    @DataBoundConstructor
    public SecretEnvVar(String key, String secretName, String secretKey, Boolean optional) {
        super(key);
        this.secretName = secretName;
        this.secretKey = secretKey;
        this.optional = optional;
    }

    @Override
    public EnvVar buildEnvVar() {
        return ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName(this.getKey())).withValueFrom(((EnvVarSourceBuilder)new EnvVarSourceBuilder().withSecretKeyRef(((SecretKeySelectorBuilder)((SecretKeySelectorBuilder)((SecretKeySelectorBuilder)new SecretKeySelectorBuilder().withKey(this.secretKey)).withName(this.secretName)).withOptional(this.optional)).build())).build())).build();
    }

    public String getSecretName() {
        return this.secretName;
    }

    public void setSecretName(String secretName) {
        this.secretName = secretName;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public Boolean getOptional() {
        return this.optional;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    @Override
    public String toString() {
        return "SecretEnvVar [secretName=" + this.secretName + ", secretKey=" + this.secretKey + ", getKey()=" + this.getKey() + ", optional=" + String.valueOf(this.getOptional()) + "]";
    }

    @Extension
    @Symbol(value={"secretEnvVar"})
    public static class DescriptorImpl
    extends Descriptor<TemplateEnvVar> {
        public String getDisplayName() {
            return "Environment Variable from Secret";
        }
    }
}

