/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.google.common.base.Objects;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.PeriodicWork;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import io.fabric8.kubernetes.client.HttpClientAware;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesFactoryAdapter;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class KubernetesClientProvider {
    private static final Logger LOGGER = Logger.getLogger(KubernetesClientProvider.class.getName());
    private static final long CACHE_EXPIRATION = Long.getLong(KubernetesClientProvider.class.getPackage().getName() + ".clients.cacheExpiration", TimeUnit.MINUTES.toSeconds(10L));
    private static final Cache<String, Client> clients = CacheBuilder.newBuilder().expireAfterWrite(CACHE_EXPIRATION, TimeUnit.SECONDS).removalListener(rl -> {
        Client client = (Client)rl.getValue();
        if (client != null) {
            LOGGER.log(Level.FINE, () -> "Expiring Kubernetes client " + rl.getKey() + " " + client.client);
        }
    }).build();
    private static volatile int runningCallsCount;
    private static volatile int queuedCallsCount;

    private KubernetesClientProvider() {
    }

    static KubernetesClient createClient(KubernetesCloud cloud) throws KubernetesAuthException, IOException {
        String displayName = cloud.getDisplayName();
        Client c = (Client)clients.getIfPresent((Object)displayName);
        if (c == null) {
            KubernetesClient client = new KubernetesFactoryAdapter(cloud.getServerUrl(), cloud.getNamespace(), cloud.getServerCertificate(), cloud.getCredentialsId(), cloud.isSkipTlsVerify(), cloud.getConnectTimeout(), cloud.getReadTimeout(), cloud.getMaxRequestsPerHost(), cloud.isUseJenkinsProxy()).createClient();
            clients.put((Object)displayName, (Object)new Client(KubernetesClientProvider.getValidity(cloud), client));
            LOGGER.log(Level.FINE, "Created new Kubernetes client: {0} {1}", new Object[]{displayName, client});
            return client;
        }
        return c.getClient();
    }

    private static int getValidity(KubernetesCloud cloud) {
        return Objects.hashCode((Object[])new Object[]{cloud.getServerUrl(), cloud.getNamespace(), cloud.getServerCertificate(), cloud.getCredentialsId(), cloud.isSkipTlsVerify(), cloud.getConnectTimeout(), cloud.getReadTimeout(), cloud.getMaxRequestsPerHostStr(), cloud.isUseJenkinsProxy()});
    }

    public static int getRunningCallsCount() {
        return runningCallsCount;
    }

    public static int getQueuedCallsCount() {
        return queuedCallsCount;
    }

    @Restricted(value={NoExternalUse.class})
    public static void invalidate(String displayName) {
        clients.invalidate((Object)displayName);
    }

    @Extension
    public static class UpdateConnectionCount
    extends PeriodicWork {
        public long getRecurrencePeriod() {
            return TimeUnit.SECONDS.toMillis(5L);
        }

        protected void doRun() {
            int runningCallsCount = 0;
            int queuedCallsCount = 0;
            for (Client client : clients.asMap().values()) {
                KubernetesClient kClient = client.getClient();
                if (!(kClient instanceof HttpClientAware)) continue;
                OkHttpClient httpClient = ((HttpClientAware)kClient).getHttpClient();
                Dispatcher dispatcher = httpClient.dispatcher();
                runningCallsCount += dispatcher.runningCallsCount();
                queuedCallsCount += dispatcher.queuedCallsCount();
            }
            runningCallsCount = runningCallsCount;
            queuedCallsCount = queuedCallsCount;
        }
    }

    @Extension
    public static class SaveableListenerImpl
    extends SaveableListener {
        public void onChange(Saveable o, XmlFile file) {
            if (o instanceof Jenkins) {
                Jenkins jenkins = (Jenkins)o;
                HashSet cloudDisplayNames = new HashSet(clients.asMap().keySet());
                for (KubernetesCloud cloud : jenkins.clouds.getAll(KubernetesCloud.class)) {
                    String displayName = cloud.getDisplayName();
                    Client client = (Client)clients.getIfPresent((Object)displayName);
                    if (client != null && client.getValidity() != KubernetesClientProvider.getValidity(cloud)) continue;
                    cloudDisplayNames.remove(displayName);
                }
                for (String displayName : cloudDisplayNames) {
                    LOGGER.log(Level.INFO, () -> "Invalidating Kubernetes client: " + displayName + clients.getIfPresent((Object)displayName));
                    KubernetesClientProvider.invalidate(displayName);
                }
            }
            super.onChange(o, file);
        }
    }

    private static class Client {
        private final KubernetesClient client;
        private final int validity;

        public Client(int validity, KubernetesClient client) {
            this.client = client;
            this.validity = validity;
        }

        public KubernetesClient getClient() {
            return this.client;
        }

        public int getValidity() {
            return this.validity;
        }
    }
}

