/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.collect.Sets;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.ListBoxModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildWrapper;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuth;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthConfig;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthException;
import org.jenkinsci.plugins.kubernetes.credentials.TokenProducer;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class KubectlBuildWrapper
extends SimpleBuildWrapper {
    private String serverUrl;
    private String credentialsId;
    private String caCertificate;

    @DataBoundConstructor
    public KubectlBuildWrapper(@Nonnull String serverUrl, @Nonnull String credentialsId, @Nonnull String caCertificate) {
        this.serverUrl = serverUrl;
        this.credentialsId = Util.fixEmpty((String)credentialsId);
        this.caCertificate = Util.fixEmptyAndTrim((String)caCertificate);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getCaCertificate() {
        return this.caCertificate;
    }

    protected Object readResolve() {
        this.credentialsId = Util.fixEmpty((String)this.credentialsId);
        this.caCertificate = Util.fixEmptyAndTrim((String)this.caCertificate);
        return this;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        if (this.credentialsId == null) {
            throw new AbortException("No credentials defined to setup Kubernetes CLI");
        }
        workspace.mkdirs();
        FilePath configFile = workspace.createTempFile(".kube", "config");
        HashSet tempFiles = Sets.newHashSet((Object[])new String[]{configFile.getRemote()});
        context.env("KUBECONFIG", configFile.getRemote());
        context.setDisposer((SimpleBuildWrapper.Disposer)new CleanupDisposer(tempFiles));
        StandardCredentials credentials = (StandardCredentials)CredentialsProvider.findCredentialById((String)this.credentialsId, StandardCredentials.class, build, Collections.emptyList());
        if (credentials == null) {
            throw new AbortException("No credentials found for id \"" + this.credentialsId + "\"");
        }
        KubernetesAuth auth = (KubernetesAuth)AuthenticationTokens.convert(KubernetesAuth.class, (Credentials)credentials);
        if (auth == null) {
            throw new AbortException("Unsupported Credentials type " + credentials.getClass().getName());
        }
        try (OutputStreamWriter w = new OutputStreamWriter(configFile.write(), StandardCharsets.UTF_8);){
            w.write(auth.buildKubeConfig(new KubernetesAuthConfig(this.getServerUrl(), this.getCaCertificate(), this.getCaCertificate() == null)));
        }
        catch (KubernetesAuthException e) {
            throw new AbortException(e.getMessage());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        String cmd = "kubectl version";
        int status = launcher.launch().cmdAsSingleString(cmd).stdout((OutputStream)out).stderr((OutputStream)err).quiet(true).envs(new String[]{"KUBECONFIG=" + configFile.getRemote()}).join();
        if (status != 0) {
            StringBuilder msgBuilder = new StringBuilder("Failed to run \"").append(cmd).append("\". Returned status code ").append(status).append(".\n");
            msgBuilder.append("stdout:\n").append(out).append("\n");
            msgBuilder.append("stderr:\n").append(err);
            throw new AbortException(msgBuilder.toString());
        }
    }

    private static class CleanupDisposer
    extends SimpleBuildWrapper.Disposer {
        private static final long serialVersionUID = 3006113419319201358L;
        private Set<String> configFiles;

        public CleanupDisposer(Set<String> tempFiles) {
            this.configFiles = tempFiles;
        }

        public void tearDown(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
            for (String configFile : this.configFiles) {
                workspace.child(configFile).delete();
            }
        }
    }

    @Extension
    @Symbol(value={"kubeconfig"})
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "Setup Kubernetes CLI (kubectl)";
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String serverUrl, @QueryParameter String credentialsId) {
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            StandardListBoxModel result = new StandardListBoxModel();
            result.includeEmptyValue();
            result.includeMatchingAs(ACL.SYSTEM, item, StandardCredentials.class, URIRequirementBuilder.fromUri((String)serverUrl).build(), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(TokenProducer.class), AuthenticationTokens.matcher(KubernetesAuth.class)}));
            return result;
        }
    }
}

