/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.Proc;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContainerExecProc
extends Proc
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(ContainerExecProc.class.getName());
    private final AtomicBoolean alive;
    private final CountDownLatch finished;
    private final ExecWatch watch;
    private final ByteArrayOutputStream error;

    @Deprecated
    public ContainerExecProc(ExecWatch watch, AtomicBoolean alive, CountDownLatch finished, Callable<Integer> exitCode) {
        this(watch, alive, finished, new ByteArrayOutputStream());
    }

    public ContainerExecProc(ExecWatch watch, AtomicBoolean alive, CountDownLatch finished, ByteArrayOutputStream error) {
        this.watch = watch;
        this.alive = alive;
        this.finished = finished;
        this.error = error;
    }

    public boolean isAlive() throws IOException, InterruptedException {
        return this.alive.get();
    }

    public void kill() throws IOException, InterruptedException {
        try {
            this.watch.getInput().write(3);
            this.watch.getInput().write("exit".getBytes(StandardCharsets.UTF_8));
            this.watch.getInput().write("\n".getBytes(StandardCharsets.UTF_8));
            this.watch.getInput().flush();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Proc kill failed, ignoring", e);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int join() throws IOException, InterruptedException {
        try {
            LOGGER.log(Level.FINEST, "Waiting for websocket to close on command finish ({0})", this.finished);
            this.finished.await();
            LOGGER.log(Level.FINEST, "Command is finished ({0})", this.finished);
            if (this.error.size() == 0) {
                int n = 0;
                return n;
            }
            ObjectMapper mapper = new ObjectMapper();
            JsonNode errorJson = mapper.readTree(this.error.toByteArray());
            if ("Success".equalsIgnoreCase(errorJson.get("status").asText())) {
                int n = 0;
                return n;
            }
            JsonNode causes = errorJson.get("details").get("causes");
            if (causes.isArray()) {
                for (JsonNode cause : causes) {
                    if (!"ExitCode".equalsIgnoreCase(cause.get("reason").asText(""))) continue;
                    int n = cause.get("message").asInt();
                    return n;
                }
            }
            LOGGER.log(Level.WARNING, "Unable to parse exit code from error message: {0}", this.error.toString(StandardCharsets.UTF_8.name()));
            int n = -1;
            return n;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error getting exit code", e);
            int n = -1;
            return n;
        }
        finally {
            this.close();
        }
    }

    public InputStream getStdout() {
        return this.watch.getOutput();
    }

    public InputStream getStderr() {
        return this.watch.getError();
    }

    public OutputStream getStdin() {
        return this.watch.getInput();
    }

    @Override
    public void close() throws IOException {
        try {
            this.watch.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "failed to close watch", e);
        }
    }
}

