/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.volumes.workspace;

import hudson.Extension;
import hudson.model.Descriptor;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.csanchez.jenkins.plugins.kubernetes.volumes.workspace.WorkspaceVolume;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class PersistentVolumeClaimWorkspaceVolume
extends WorkspaceVolume {
    private String claimName;
    @CheckForNull
    private Boolean readOnly;

    @DataBoundConstructor
    public PersistentVolumeClaimWorkspaceVolume(String claimName, Boolean readOnly) {
        this.claimName = claimName;
        this.readOnly = readOnly;
    }

    public String getClaimName() {
        return this.claimName;
    }

    @Nonnull
    public Boolean getReadOnly() {
        return this.readOnly != null && this.readOnly != false;
    }

    @Override
    public Volume buildVolume(String volumeName) {
        return ((VolumeBuilder)((VolumeFluent.PersistentVolumeClaimNested)((VolumeFluent.PersistentVolumeClaimNested)((VolumeBuilder)new VolumeBuilder().withName(volumeName)).withNewPersistentVolumeClaim().withClaimName(this.getClaimName())).withReadOnly(this.getReadOnly())).and()).build();
    }

    @Extension
    @Symbol(value={"persistentVolumeClaimWorkspaceVolume"})
    public static class DescriptorImpl
    extends Descriptor<WorkspaceVolume> {
        public String getDisplayName() {
            return "Persistent Volume Claim Workspace Volume";
        }
    }
}

