/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import hudson.BulkChange;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.Run;
import hudson.model.Saveable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;

public class PodTemplateAction
extends InvisibleAction {
    private static final Logger LOGGER = Logger.getLogger(PodTemplateAction.class.getName());
    private final Stack<String> names = new Stack();
    private final Run run;

    PodTemplateAction(Run run) {
        this.run = run;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(String template) throws IOException {
        if (this.run == null) {
            LOGGER.warning("run is null, cannot push");
            return;
        }
        Run run = this.run;
        synchronized (run) {
            BulkChange bc = new BulkChange((Saveable)this.run);
            try {
                PodTemplateAction action = (PodTemplateAction)this.run.getAction(PodTemplateAction.class);
                if (action == null) {
                    action = new PodTemplateAction(this.run);
                    this.run.addAction((Action)action);
                }
                action.names.push(template);
                bc.commit();
            }
            finally {
                bc.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pop() throws IOException {
        if (this.run == null) {
            LOGGER.warning("run is null, cannot pop");
            return null;
        }
        Run run = this.run;
        synchronized (run) {
            BulkChange bc = new BulkChange((Saveable)this.run);
            try {
                PodTemplateAction action = (PodTemplateAction)this.run.getAction(PodTemplateAction.class);
                if (action == null) {
                    action = new PodTemplateAction(this.run);
                    this.run.addAction((Action)action);
                }
                String template = action.names.pop();
                bc.commit();
                String string = template;
                return string;
            }
            finally {
                bc.abort();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getParentTemplateList() {
        Run run = this.run;
        synchronized (run) {
            PodTemplateAction action = (PodTemplateAction)this.run.getAction(PodTemplateAction.class);
            if (action == null) {
                action = new PodTemplateAction(this.run);
                this.run.addAction((Action)action);
            }
            return new ArrayList<String>(action.names);
        }
    }

    public String getParentTemplates() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String template : this.getParentTemplateList()) {
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            sb.append(template);
        }
        return sb.toString();
    }
}

