/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes.pipeline;

import hudson.AbortException;
import hudson.FilePath;
import hudson.LauncherDecorator;
import hudson.model.Node;
import hudson.model.TaskListener;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesSlave;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerExecDecorator;
import org.csanchez.jenkins.plugins.kubernetes.pipeline.ContainerStep;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class ContainerStepExecution
extends AbstractStepExecutionImpl {
    private static final long serialVersionUID = 7634132798345235774L;
    private static final transient Logger LOGGER = Logger.getLogger(ContainerStepExecution.class.getName());
    private static final transient String HOSTNAME_FILE = "/etc/hostname";
    private final ContainerStep step;
    private transient KubernetesClient client;
    private transient ContainerExecDecorator decorator;

    ContainerStepExecution(ContainerStep step, StepContext context) {
        super(context);
        this.step = step;
    }

    public boolean start() throws Exception {
        LOGGER.log(Level.FINE, "Starting container step.");
        FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
        String podName = workspace.child(HOSTNAME_FILE).readToString().trim();
        String namespace = workspace.child("/var/run/secrets/kubernetes.io/serviceaccount/namespace").readToString().trim();
        String containerName = this.step.getName();
        Node node = (Node)this.getContext().get(Node.class);
        if (!(node instanceof KubernetesSlave)) {
            throw new AbortException(String.format("Node is not a Kubernetes node: %s", node.getNodeName()));
        }
        KubernetesSlave slave = (KubernetesSlave)node;
        KubernetesCloud cloud = (KubernetesCloud)slave.getCloud();
        if (cloud == null) {
            throw new AbortException(String.format("Cloud does not exist: %s", slave.getCloudName()));
        }
        this.client = cloud.connect();
        this.decorator = new ContainerExecDecorator(this.client, podName, containerName, namespace);
        this.getContext().newBodyInvoker().withContext((Object)BodyInvoker.mergeLauncherDecorators((LauncherDecorator)((LauncherDecorator)this.getContext().get(LauncherDecorator.class)), (LauncherDecorator)this.decorator)).withCallback((BodyExecutionCallback)new ContainerExecCallback(new Closeable[]{this.decorator})).start();
        return false;
    }

    public void stop(Throwable cause) throws Exception {
        LOGGER.log(Level.FINE, "Stopping container step.");
        this.closeQuietly(new Closeable[]{this.client, this.decorator});
    }

    private void closeQuietly(Closeable ... closeables) {
        ContainerStepExecution.closeQuietly(this.getContext(), closeables);
    }

    private static void closeQuietly(StepContext context, Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (IOException e) {
                try {
                    ((TaskListener)context.get(TaskListener.class)).error("Error while closing: [" + c + "]");
                }
                catch (IOException | InterruptedException e1) {
                    LOGGER.log(Level.WARNING, "Error writing to task listener", e);
                }
            }
        }
    }

    private static class ContainerExecCallback
    extends BodyExecutionCallback {
        private static final long serialVersionUID = 6385838254761750483L;
        private final Closeable[] closeables;

        private ContainerExecCallback(Closeable ... closeables) {
            this.closeables = closeables;
        }

        public void onSuccess(StepContext context, Object result) {
            context.onSuccess(result);
            ContainerStepExecution.closeQuietly(context, this.closeables);
        }

        public void onFailure(StepContext context, Throwable t) {
            context.onFailure(t);
            ContainerStepExecution.closeQuietly(context, this.closeables);
        }
    }
}

