/*
 * Decompiled with CFR 0.152.
 */
package org.csanchez.jenkins.plugins.kubernetes;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.Cloud;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesCloud;
import org.csanchez.jenkins.plugins.kubernetes.KubernetesComputer;
import org.csanchez.jenkins.plugins.kubernetes.Messages;
import org.csanchez.jenkins.plugins.kubernetes.PodTemplate;
import org.jenkinsci.plugins.durabletask.executors.OnceRetentionStrategy;
import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.DataBoundConstructor;

public class KubernetesSlave
extends AbstractCloudSlave {
    private static final Logger LOGGER = Logger.getLogger(KubernetesSlave.class.getName());
    private static final long serialVersionUID = -8642936855413034232L;
    private static final String DEFAULT_AGENT_PREFIX = "jenkins-agent";
    private static final ResourceBundleHolder HOLDER = ResourceBundleHolder.get(Messages.class);
    private final String cloudName;
    private final String namespace;

    public KubernetesSlave(PodTemplate template, String nodeDescription, KubernetesCloud cloud, String labelStr) throws Descriptor.FormException, IOException {
        this(template, nodeDescription, cloud, labelStr, (RetentionStrategy)new OnceRetentionStrategy(cloud.getRetentionTimeout()));
    }

    @Deprecated
    public KubernetesSlave(PodTemplate template, String nodeDescription, KubernetesCloud cloud, Label label) throws Descriptor.FormException, IOException {
        this(template, nodeDescription, cloud, label.toString(), (RetentionStrategy)new OnceRetentionStrategy(cloud.getRetentionTimeout()));
    }

    @Deprecated
    public KubernetesSlave(PodTemplate template, String nodeDescription, KubernetesCloud cloud, String labelStr, RetentionStrategy rs) throws Descriptor.FormException, IOException {
        this(template, nodeDescription, cloud.name, labelStr, rs);
    }

    @DataBoundConstructor
    public KubernetesSlave(PodTemplate template, String nodeDescription, String cloudName, String labelStr, RetentionStrategy rs) throws Descriptor.FormException, IOException {
        super(KubernetesSlave.getSlaveName(template), nodeDescription, template.getRemoteFs(), 1, template.getNodeUsageMode() != null ? template.getNodeUsageMode() : Node.Mode.NORMAL, labelStr == null ? null : labelStr, (ComputerLauncher)new JNLPLauncher(), rs, template.getNodeProperties());
        this.cloudName = cloudName;
        this.namespace = template.getNamespace();
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Cloud getCloud() {
        return Jenkins.getInstance().getCloud(this.getCloudName());
    }

    static String getSlaveName(PodTemplate template) {
        String randString = RandomStringUtils.random((int)5, (String)"bcdfghjklmnpqrstvwxz0123456789");
        String name = template.getName();
        if (StringUtils.isEmpty((String)name)) {
            return String.format("%s-%s", DEFAULT_AGENT_PREFIX, randString);
        }
        name = name.replaceAll("[ _]", "-").toLowerCase();
        name = name.substring(0, Math.min(name.length(), 62 - randString.length()));
        return String.format("%s-%s", name, randString);
    }

    public KubernetesComputer createComputer() {
        return new KubernetesComputer(this);
    }

    protected void _terminate(TaskListener listener) throws IOException, InterruptedException {
        LOGGER.log(Level.INFO, "Terminating Kubernetes instance for slave {0}", this.name);
        Computer computer = this.toComputer();
        if (computer == null) {
            String msg = String.format("Computer for slave is null: %s", this.name);
            LOGGER.log(Level.SEVERE, msg);
            listener.fatalError(msg);
            return;
        }
        if (this.getCloudName() == null) {
            String msg = String.format("Cloud name is not set for slave, can't terminate: %s", this.name);
            LOGGER.log(Level.SEVERE, msg);
            listener.fatalError(msg);
            return;
        }
        try {
            Cloud cloud = this.getCloud();
            if (cloud == null) {
                String msg = String.format("Slave cloud no longer exists: %s", this.getCloudName());
                LOGGER.log(Level.WARNING, msg);
                listener.fatalError(msg);
                return;
            }
            if (!(cloud instanceof KubernetesCloud)) {
                String msg = String.format("Slave cloud is not a KubernetesCloud, something is very wrong: %s", this.getCloudName());
                LOGGER.log(Level.SEVERE, msg);
                listener.fatalError(msg);
                return;
            }
            KubernetesClient client = ((KubernetesCloud)cloud).connect();
            PodResource pods = (PodResource)((NonNamespaceOperation)client.pods().inNamespace(this.namespace)).withName(this.name);
            pods.delete();
            String msg = String.format("Terminated Kubernetes instance for slave %s", this.name);
            LOGGER.log(Level.INFO, msg);
            listener.getLogger().println(msg);
            computer.disconnect(OfflineCause.create((Localizable)new Localizable(HOLDER, "offline", new Object[0])));
            LOGGER.log(Level.INFO, "Disconnected computer {0}", this.name);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to terminate pod for slave " + this.name, e);
        }
    }

    public String toString() {
        return String.format("KubernetesSlave name: %s", this.name);
    }

    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public String getDisplayName() {
            return "Kubernetes Slave";
        }

        public boolean isInstantiable() {
            return false;
        }
    }
}

