/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.search.service.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.craftercms.search.service.Query;

public abstract class QueryParams
implements Query {
    private Map<String, String[]> params;

    public QueryParams() {
        this.params = new LinkedHashMap<String, String[]>();
    }

    public QueryParams(Map<String, String[]> params) {
        this.params = new LinkedHashMap<String, String[]>(params);
    }

    public boolean hasParam(String name) {
        return this.params.containsKey(name);
    }

    public String[] getParam(String name) {
        return this.params.get(name);
    }

    public QueryParams addParam(String name, String value) {
        Object[] oldValues = this.params.get(name);
        String[] values = ArrayUtils.isNotEmpty((Object[])oldValues) ? (String[])ArrayUtils.add((Object[])oldValues, (Object)value) : new String[]{value};
        this.params.put(name, values);
        return this;
    }

    public QueryParams addParam(String name, String ... values) {
        Object[] oldValues = this.params.get(name);
        if (ArrayUtils.isNotEmpty((Object[])oldValues)) {
            values = (String[])ArrayUtils.addAll((Object[])oldValues, (Object[])values);
        }
        this.params.put(name, values);
        return this;
    }

    public Map<String, String[]> getParams() {
        return this.params;
    }

    @Override
    public String toQueryString() {
        StringBuilder queryStr = new StringBuilder();
        for (Map.Entry<String, String[]> param : this.params.entrySet()) {
            String name = param.getKey();
            for (String value : param.getValue()) {
                if (queryStr.length() > 0) {
                    queryStr.append('&');
                }
                try {
                    queryStr.append(name).append('=').append(URLEncoder.encode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException();
                }
            }
        }
        return queryStr.toString();
    }

    public String toString() {
        return this.toQueryString();
    }
}

