/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.xml.mergers.impl.strategies;

import java.util.ArrayList;
import java.util.List;
import org.craftercms.core.exception.XmlMergeException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.xml.mergers.DescriptorMergeStrategy;
import org.craftercms.core.xml.mergers.DescriptorMergeStrategyResolver;
import org.craftercms.core.xml.mergers.MergeableDescriptor;
import org.dom4j.Document;
import org.dom4j.Node;

public class ExplicitParentMergeStrategy
implements DescriptorMergeStrategy {
    private DescriptorMergeStrategyResolver mergeStrategyResolver;
    private String parentDescriptorElementXPathQuery;

    public ExplicitParentMergeStrategy(DescriptorMergeStrategyResolver mergeStrategyResolver, String parentDescriptorElementXPathQuery) {
        this.mergeStrategyResolver = mergeStrategyResolver;
        this.parentDescriptorElementXPathQuery = parentDescriptorElementXPathQuery;
    }

    @Override
    public List<MergeableDescriptor> getDescriptors(Context context, CachingOptions cachingOptions, String mainDescriptorUrl, Document mainDescriptorDom) throws XmlMergeException {
        return this.getDescriptors(context, cachingOptions, mainDescriptorUrl, mainDescriptorDom, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<MergeableDescriptor> getDescriptors(Context context, CachingOptions cachingOptions, String mainDescriptorUrl, Document mainDescriptorDom, boolean mainDescriptorOptional) throws XmlMergeException {
        Node parentDescriptorElem = mainDescriptorDom.selectSingleNode(this.parentDescriptorElementXPathQuery);
        ArrayList<MergeableDescriptor> descriptors = new ArrayList<MergeableDescriptor>();
        if (parentDescriptorElem == null) throw new XmlMergeException("No parent descriptor element specified");
        String parentDescriptorUrl = parentDescriptorElem.getText();
        Document parentDescriptorDom = this.getDescriptorDom(context, cachingOptions, parentDescriptorUrl);
        if (parentDescriptorDom == null) throw new XmlMergeException("No parent descriptor found at " + parentDescriptorUrl);
        DescriptorMergeStrategy parentMergeStrategy = this.mergeStrategyResolver.getStrategy(parentDescriptorUrl, parentDescriptorDom);
        if (parentMergeStrategy != null) {
            descriptors.addAll(parentMergeStrategy.getDescriptors(context, cachingOptions, parentDescriptorUrl, parentDescriptorDom, true));
        }
        descriptors.add(new MergeableDescriptor(mainDescriptorUrl, mainDescriptorOptional));
        return descriptors;
    }

    protected Document getDescriptorDom(Context context, CachingOptions cachingOptions, String url) {
        Item item = context.getStoreAdapter().findItem(context, cachingOptions, url, true);
        if (item != null) {
            return item.getDescriptorDom();
        }
        return null;
    }
}

