/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.xml.mergers.impl.resolvers;

import java.util.Map;
import org.craftercms.core.exception.XmlException;
import org.craftercms.core.xml.mergers.DescriptorMergeStrategy;
import org.craftercms.core.xml.mergers.DescriptorMergeStrategyResolver;
import org.dom4j.Document;
import org.dom4j.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class MetaDataMergeStrategyResolver
implements DescriptorMergeStrategyResolver {
    private String mergeStrategyElementXPathQuery;
    private Map<String, DescriptorMergeStrategy> elementValueToStrategyMappings;

    public MetaDataMergeStrategyResolver(String mergeStrategyElementXPathQuery) {
        this.mergeStrategyElementXPathQuery = mergeStrategyElementXPathQuery;
    }

    @Autowired
    public void setElementValueToStrategyMappings(@Lazy Map<String, DescriptorMergeStrategy> elementValueToStrategyMappings) {
        this.elementValueToStrategyMappings = elementValueToStrategyMappings;
    }

    @Override
    public DescriptorMergeStrategy getStrategy(String descriptorUrl, Document descriptorDom) throws XmlException {
        if (descriptorDom != null) {
            Node element = descriptorDom.selectSingleNode(this.mergeStrategyElementXPathQuery);
            if (element != null) {
                DescriptorMergeStrategy strategy = this.elementValueToStrategyMappings.get(element.getText());
                if (strategy != null) {
                    return strategy;
                }
                throw new XmlException("Element value \"" + element.getText() + "\" doesn't refer to an registered strategy");
            }
            return null;
        }
        return null;
    }
}

