/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.xml.mergers.impl.cues.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.craftercms.core.xml.mergers.impl.cues.MergeCue;
import org.craftercms.core.xml.mergers.impl.cues.MergeCueContext;
import org.craftercms.core.xml.mergers.impl.cues.MergeCueResolver;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.QName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class MergeCueResolverImpl
implements MergeCueResolver {
    protected Map<QName, MergeCue> parentMergeCues;
    protected Map<QName, MergeCue> childMergeCues;
    protected MergeCue defaultParentMergeCue;
    protected MergeCue defaultChildMergeCue;

    @Autowired
    public void setParentMergeCues(@Lazy Map<QName, MergeCue> parentMergeCues) {
        this.parentMergeCues = parentMergeCues;
    }

    @Autowired
    public void setChildMergeCues(@Lazy Map<QName, MergeCue> childMergeCues) {
        this.childMergeCues = childMergeCues;
    }

    @Autowired
    public void setDefaultParentMergeCue(MergeCue defaultParentMergeCue) {
        this.defaultParentMergeCue = defaultParentMergeCue;
    }

    @Autowired
    public void setDefaultChildMergeCue(MergeCue defaultChildMergeCue) {
        this.defaultChildMergeCue = defaultChildMergeCue;
    }

    @Override
    public MergeCueContext getMergeCue(Element parent, Element child) {
        Map<String, String> mergeCueParams;
        MergeCue chosenMergeCue;
        Attribute parentMergeCueAttribute = this.getMergeCueAttribute(parent, this.parentMergeCues);
        MergeCue parentMergeCue = parentMergeCueAttribute != null ? this.parentMergeCues.get(parentMergeCueAttribute.getQName()) : this.defaultParentMergeCue;
        Attribute childMergeCueAttribute = this.getMergeCueAttribute(child, this.childMergeCues);
        MergeCue childMergeCue = childMergeCueAttribute != null ? this.childMergeCues.get(childMergeCueAttribute.getQName()) : this.defaultChildMergeCue;
        if (parentMergeCue.getPriority() > childMergeCue.getPriority()) {
            chosenMergeCue = parentMergeCue;
            mergeCueParams = parentMergeCueAttribute != null ? this.getMergeCueParams(parent, parentMergeCueAttribute) : Collections.emptyMap();
        } else {
            chosenMergeCue = childMergeCue;
            mergeCueParams = childMergeCueAttribute != null ? this.getMergeCueParams(child, childMergeCueAttribute) : Collections.emptyMap();
        }
        return new MergeCueContext(chosenMergeCue, parent, child, mergeCueParams);
    }

    protected Attribute getMergeCueAttribute(Element element, Map<QName, MergeCue> mergeCues) {
        List attributes = element.attributes();
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            if (!mergeCues.containsKey(attribute.getQName())) continue;
            i.remove();
            return attribute;
        }
        return null;
    }

    protected Map<String, String> getMergeCueParams(Element element, Attribute mergeCueAttribute) {
        HashMap<String, String> params = new HashMap<String, String>();
        String paramsPrefix = mergeCueAttribute.getQualifiedName() + "-";
        List attributes = element.attributes();
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            String attributeQualifiedName = attribute.getQualifiedName();
            if (!attributeQualifiedName.startsWith(paramsPrefix)) continue;
            i.remove();
            String paramName = attributeQualifiedName.substring(paramsPrefix.length());
            String paramValue = attribute.getValue();
            params.put(paramName, paramValue);
        }
        return params;
    }
}

