/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.util.template.impl.spel;

import java.io.IOException;
import java.io.Writer;
import org.craftercms.core.exception.TemplateException;
import org.craftercms.core.util.template.CompiledTemplate;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;

public class SpElCompiledTemplate
implements CompiledTemplate {
    private Expression expression;
    private EvaluationContext evaluationContext;

    public SpElCompiledTemplate(Expression expression, EvaluationContext evaluationContext) {
        this.expression = expression;
        this.evaluationContext = evaluationContext;
    }

    @Override
    public void process(Object model, Writer output) throws TemplateException {
        try {
            String result = (String)this.expression.getValue(this.evaluationContext, model, String.class);
            output.write(result);
            output.flush();
        }
        catch (IOException e) {
            throw new TemplateException("An I/O error occurred while writing to output", e);
        }
        catch (Exception e) {
            throw new TemplateException("Unable to process SpEL template:\n" + this.expression.getExpressionString(), e);
        }
    }
}

