/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.util.cache.impl;

import org.craftercms.core.events.ContextCreatedEvent;
import org.craftercms.core.events.ContextDestroyedEvent;
import org.craftercms.core.events.ContextEvent;
import org.craftercms.core.service.CacheService;
import org.craftercms.core.service.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;

public class ApplicationCacheLifecycleManager
implements ApplicationListener<ContextEvent> {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationCacheLifecycleManager.class);
    protected CacheService appCacheService;

    public ApplicationCacheLifecycleManager(CacheService appCacheService) {
        this.appCacheService = appCacheService;
    }

    public synchronized void onApplicationEvent(ContextEvent event) {
        Context context = event.getContext();
        if (event instanceof ContextCreatedEvent) {
            if (!this.appCacheService.hasScope(context)) {
                logger.info("Adding application cache scope for context: {}", (Object)context);
                this.appCacheService.addScope(context);
            }
        } else if (event instanceof ContextDestroyedEvent) {
            logger.info("Removing application cache scope for context: {}", (Object)context);
            this.appCacheService.removeScope(context);
        }
    }

    public boolean supportsAsyncExecution() {
        return false;
    }
}

