/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.store.impl.filesystem;

import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.core.exception.AuthenticationException;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.RootFolderNotFoundException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.Context;
import org.craftercms.core.store.impl.AbstractFileBasedContentStoreAdapter;
import org.craftercms.core.store.impl.File;
import org.craftercms.core.store.impl.filesystem.FileSystemContent;
import org.craftercms.core.store.impl.filesystem.FileSystemContext;
import org.craftercms.core.store.impl.filesystem.FileSystemFile;
import org.craftercms.core.util.cache.CacheTemplate;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.validation.Validator;

public class FileSystemContentStoreAdapter
extends AbstractFileBasedContentStoreAdapter
implements ResourceLoaderAware {
    public static final String STORE_TYPE = "filesystem";
    private ResourceLoader resourceLoader;

    public FileSystemContentStoreAdapter(Validator pathValidator, String descriptorFileExtension, String metadataFileExtension, CacheTemplate cacheTemplate) {
        super(pathValidator, descriptorFileExtension, metadataFileExtension, cacheTemplate);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public Context createContext(String id, String rootFolderPath, boolean mergingOn, boolean cacheOn, int maxAllowedItemsInCache, boolean ignoreHiddenFiles, Map<String, String> configurationVariables) throws RootFolderNotFoundException, StoreException, AuthenticationException {
        FileSystemFile rootFolder;
        Resource rootFolderResource = this.resourceLoader.getResource(rootFolderPath);
        if (!rootFolderResource.exists()) {
            throw new RootFolderNotFoundException("Root folder " + rootFolderPath + " not found (make sure that it has a valid URL prefix (e.g. file:))");
        }
        try {
            rootFolder = new FileSystemFile(rootFolderResource.getFile());
        }
        catch (IOException e) {
            throw new StoreException("Unable to retrieve file handle for root folder " + rootFolderPath, e);
        }
        return new FileSystemContext(id, this, rootFolderPath, rootFolder, mergingOn, cacheOn, maxAllowedItemsInCache, ignoreHiddenFiles, configurationVariables);
    }

    @Override
    public boolean validate(Context context) throws InvalidContextException, StoreException, AuthenticationException {
        FileSystemFile rootFolder = ((FileSystemContext)context).getRootFolder();
        return rootFolder.getFile().exists();
    }

    @Override
    public void destroyContext(Context context) throws InvalidContextException, StoreException, AuthenticationException {
    }

    @Override
    protected Content getContent(Context context, CachingOptions cachingOptions, File file) throws InvalidContextException, StoreException {
        return new FileSystemContent(((FileSystemFile)file).getFile());
    }

    @Override
    protected File findFile(Context context, CachingOptions cachingOptions, String path) {
        FileSystemFile rootFolder = ((FileSystemContext)context).getRootFolder();
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            FileSystemFile file = new FileSystemFile(rootFolder, path);
            if (file.getFile().exists()) {
                return file;
            }
            return null;
        }
        return rootFolder;
    }

    @Override
    protected List<File> getChildren(Context context, CachingOptions cachingOptions, File dir) {
        java.io.File[] listing = context.ignoreHiddenFiles() ? ((FileSystemFile)dir).getFile().listFiles(IgnoreHiddenFileFilter.INSTANCE) : ((FileSystemFile)dir).getFile().listFiles();
        if (listing != null) {
            ArrayList<File> children = new ArrayList<File>(listing.length);
            for (java.io.File file : listing) {
                children.add(new FileSystemFile(file));
            }
            return children;
        }
        return null;
    }

    private static class IgnoreHiddenFileFilter
    implements FileFilter {
        public static final IgnoreHiddenFileFilter INSTANCE = new IgnoreHiddenFileFilter();

        private IgnoreHiddenFileFilter() {
        }

        @Override
        public boolean accept(java.io.File pathname) {
            return !pathname.isHidden();
        }
    }
}

