/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.store.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.craftercms.commons.validation.ValidationResult;
import org.craftercms.commons.validation.ValidationUtils;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.InvalidScopeException;
import org.craftercms.core.exception.PathNotFoundException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.exception.XmlFileParseException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.store.impl.AbstractCachedContentStoreAdapter;
import org.craftercms.core.store.impl.File;
import org.craftercms.core.util.ContentStoreUtils;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.core.util.cache.impl.CachingAwareList;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.Validator;
import org.xml.sax.SAXException;

public abstract class AbstractFileBasedContentStoreAdapter
extends AbstractCachedContentStoreAdapter {
    public static final String DEFAULT_CHARSET = "UTF-8";
    protected Validator pathValidator;
    protected String charset;
    protected String descriptorFileExtension;
    protected String metadataFileExtension;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFileBasedContentStoreAdapter.class);

    public AbstractFileBasedContentStoreAdapter(Validator pathValidator, String descriptorFileExtension, String metadataFileExtension, CacheTemplate cacheTemplate) {
        super(cacheTemplate);
        this.pathValidator = pathValidator;
        this.descriptorFileExtension = descriptorFileExtension;
        this.metadataFileExtension = metadataFileExtension;
        this.charset = DEFAULT_CHARSET;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public boolean doExists(Context context, CachingOptions cachingOptions, String path) throws InvalidScopeException, StoreException {
        return this.findFile(context, cachingOptions, path) != null;
    }

    @Override
    protected Content doFindContent(Context context, CachingOptions cachingOptions, String path) throws InvalidContextException, StoreException {
        this.validatePath(path);
        path = ContentStoreUtils.normalizePath(path);
        File file = this.findFile(context, cachingOptions, path);
        if (file == null) {
            return null;
        }
        if (!file.isFile()) {
            throw new StoreException("Unable to find content: " + String.valueOf(file) + " is not a file");
        }
        return this.getContent(context, cachingOptions, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Item doFindItem(Context context, CachingOptions cachingOptions, String path, boolean withDescriptor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, StoreException {
        this.validatePath(path);
        path = ContentStoreUtils.normalizePath(path);
        File file = this.findFile(context, cachingOptions, path);
        if (file == null) {
            return null;
        }
        Item item = new Item();
        item.setName(file.getName());
        item.setUrl(path);
        item.setFolder(file.isDirectory());
        if (withDescriptor) {
            File descriptorFile;
            if (file.isFile() && item.getName().endsWith(this.descriptorFileExtension)) {
                item.setDescriptorUrl(path);
                descriptorFile = file;
            } else {
                String descriptorPath = FilenameUtils.removeExtension((String)path) + this.metadataFileExtension;
                item.setDescriptorUrl(descriptorPath);
                descriptorFile = this.findFile(context, cachingOptions, descriptorPath);
                if (descriptorFile != null && !descriptorFile.isFile()) {
                    throw new StoreException("Descriptor file at " + String.valueOf(descriptorFile) + " is not really a file");
                }
            }
            if (descriptorFile != null) {
                try {
                    InputStream fileInputStream = this.getContent(context, cachingOptions, descriptorFile).getInputStream();
                    InputStreamReader fileReader = new InputStreamReader(fileInputStream, this.charset);
                    try {
                        item.setDescriptorDom(this.createXmlReader().read((Reader)fileReader));
                    }
                    finally {
                        IOUtils.closeQuietly((Reader)fileReader);
                    }
                }
                catch (IOException e) {
                    throw new StoreException("Unable to open input stream for descriptor file at " + String.valueOf(descriptorFile), e);
                }
                catch (DocumentException e) {
                    throw new XmlFileParseException("Error while parsing xml document at " + String.valueOf(descriptorFile), e);
                }
            }
        }
        return item;
    }

    @Override
    protected List<Item> doFindItems(Context context, CachingOptions cachingOptions, String path) throws InvalidContextException, PathNotFoundException, XmlFileParseException, StoreException {
        this.validatePath(path);
        path = ContentStoreUtils.normalizePath(path);
        File dir = this.findFile(context, cachingOptions, path);
        if (dir == null) {
            return null;
        }
        if (!dir.isDirectory()) {
            throw new StoreException(String.format("The path '%s' doesn't correspond to a dir", path));
        }
        List<File> children = this.getChildren(context, cachingOptions, dir);
        CachingAwareList<Item> items = new CachingAwareList<Item>(children.size());
        if (CollectionUtils.isNotEmpty(children)) {
            for (File child : children) {
                String fileRelPath;
                Item item;
                if (child.isFile() && child.getName().endsWith(this.metadataFileExtension) || (item = this.findItem(context, cachingOptions, fileRelPath = path + (!path.equals("/") ? "/" : "") + child.getName(), false)) == null) continue;
                items.add(item);
            }
        }
        return items;
    }

    protected SAXReader createXmlReader() {
        SAXReader xmlReader = new SAXReader();
        xmlReader.setMergeAdjacentText(true);
        xmlReader.setStripWhitespaceText(true);
        xmlReader.setIgnoreComments(true);
        try {
            xmlReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            xmlReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (SAXException ex) {
            LOGGER.error("Unable to turn off external entity loading, This could be a security risk.", (Throwable)ex);
        }
        return xmlReader;
    }

    protected void validatePath(String path) throws StoreException {
        ValidationResult result = ValidationUtils.validateValue((Validator)this.pathValidator, (Object)path, (String)"path");
        if (result.hasErrors()) {
            throw new StoreException(String.format("Validation of path '%s' failed. Errors: %s", path, result.getErrors()));
        }
    }

    protected abstract Content getContent(Context var1, CachingOptions var2, File var3) throws InvalidContextException, StoreException;

    protected abstract File findFile(Context var1, CachingOptions var2, String var3) throws InvalidContextException, StoreException;

    protected abstract List<File> getChildren(Context var1, CachingOptions var2, File var3) throws InvalidContextException, StoreException;
}

