/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.store.impl;

import java.util.List;
import org.craftercms.commons.lang.Callback;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.exception.XmlFileParseException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.store.ContentStoreAdapter;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.core.util.cache.impl.CachingAwareList;

public abstract class AbstractCachedContentStoreAdapter
implements ContentStoreAdapter {
    public static final String CONST_KEY_ELEM_CONTENT = "contentStoreAdapter.content";
    public static final String CONST_KEY_ELEM_ITEM = "contentStoreAdapter.item";
    public static final String CONST_KEY_ELEM_ITEMS = "contentStoreAdapter.items";
    public static final String CONST_KEY_ELEM_EXISTS = "contentStoreAdapter.exists";
    protected CacheTemplate cacheTemplate;
    protected CachingOptions defaultCachingOptions;

    public AbstractCachedContentStoreAdapter(CacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    public void setDefaultCachingOptions(CachingOptions defaultCachingOptions) {
        this.defaultCachingOptions = defaultCachingOptions;
    }

    @Override
    public boolean exists(final Context context, CachingOptions cachingOptions, final String path) throws InvalidContextException, StoreException {
        final CachingOptions actualCachingOptions = cachingOptions != null ? cachingOptions : this.defaultCachingOptions;
        return this.cacheTemplate.getObject(context, actualCachingOptions, new Callback<Boolean>(){

            public Boolean execute() {
                return AbstractCachedContentStoreAdapter.this.doExists(context, actualCachingOptions, path);
            }

            public String toString() {
                return String.format(AbstractCachedContentStoreAdapter.this.getClass().getName() + ".exists(%s, %s)", context, path);
            }
        }, path, CONST_KEY_ELEM_EXISTS);
    }

    @Override
    public Content findContent(final Context context, CachingOptions cachingOptions, final String path) throws InvalidContextException, StoreException {
        final CachingOptions actualCachingOptions = cachingOptions != null ? cachingOptions : this.defaultCachingOptions;
        return this.cacheTemplate.getObject(context, actualCachingOptions, new Callback<Content>(){

            public Content execute() {
                return AbstractCachedContentStoreAdapter.this.doFindContent(context, actualCachingOptions, path);
            }

            public String toString() {
                return String.format(AbstractCachedContentStoreAdapter.this.getClass().getName() + ".findContent(%s, %s)", context, path);
            }
        }, path, CONST_KEY_ELEM_CONTENT);
    }

    @Override
    public Item findItem(final Context context, CachingOptions cachingOptions, final String path, final boolean withDescriptor) throws InvalidContextException, XmlFileParseException, StoreException {
        final CachingOptions actualCachingOptions = cachingOptions != null ? cachingOptions : this.defaultCachingOptions;
        return this.cacheTemplate.getObject(context, actualCachingOptions, new Callback<Item>(){

            public Item execute() {
                return AbstractCachedContentStoreAdapter.this.doFindItem(context, actualCachingOptions, path, withDescriptor);
            }

            public String toString() {
                return String.format(AbstractCachedContentStoreAdapter.this.getClass().getName() + ".findItem(%s, %s, %s)", context, path, withDescriptor);
            }
        }, path, withDescriptor, CONST_KEY_ELEM_ITEM);
    }

    @Override
    public List<Item> findItems(final Context context, CachingOptions cachingOptions, final String path) throws InvalidContextException, XmlFileParseException, StoreException {
        final CachingOptions actualCachingOptions = cachingOptions != null ? cachingOptions : this.defaultCachingOptions;
        return this.cacheTemplate.getObject(context, actualCachingOptions, new Callback<List<Item>>(){

            public List<Item> execute() {
                List<Item> items = AbstractCachedContentStoreAdapter.this.doFindItems(context, actualCachingOptions, path);
                if (items != null) {
                    if (items instanceof CachingAwareList) {
                        return items;
                    }
                    return new CachingAwareList<Item>(items);
                }
                return null;
            }

            public String toString() {
                return String.format(AbstractCachedContentStoreAdapter.this.getClass().getName() + ".findItems(%s, %s)", context, path);
            }
        }, path, CONST_KEY_ELEM_ITEMS);
    }

    protected abstract boolean doExists(Context var1, CachingOptions var2, String var3) throws InvalidContextException, StoreException;

    protected abstract Content doFindContent(Context var1, CachingOptions var2, String var3) throws InvalidContextException, StoreException;

    protected abstract Item doFindItem(Context var1, CachingOptions var2, String var3, boolean var4) throws InvalidContextException, XmlFileParseException, StoreException;

    protected abstract List<Item> doFindItems(Context var1, CachingOptions var2, String var3) throws InvalidContextException, XmlFileParseException, StoreException;
}

