/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.service.impl;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.craftercms.commons.lang.RegexUtils;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.ItemFilter;

public class ExcludeByUrlItemFilter
implements ItemFilter {
    private String[] excludeRegexes;

    public ExcludeByUrlItemFilter(String[] excludeRegexes) {
        this.excludeRegexes = excludeRegexes;
    }

    @Override
    public boolean runBeforeProcessing() {
        return true;
    }

    @Override
    public boolean runAfterProcessing() {
        return false;
    }

    @Override
    public boolean accepts(Item item, List<Item> acceptedItems, List<Item> rejectedItems, boolean runningBeforeProcessing) {
        return ArrayUtils.isEmpty((Object[])this.excludeRegexes) || !RegexUtils.matchesAny((String)item.getUrl(), (String[])this.excludeRegexes);
    }

    public String toString() {
        return "ExcludeByUrlItemFilter{excludeRegexes=" + Arrays.toString(this.excludeRegexes) + "}";
    }
}

