/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.ConfigurationProvider;
import org.craftercms.commons.file.blob.Blob;
import org.craftercms.commons.file.blob.BlobStore;
import org.craftercms.commons.file.blob.BlobStoreResolver;
import org.craftercms.commons.file.blob.BlobUrlResolver;
import org.craftercms.core.events.ContextCreatedEvent;
import org.craftercms.core.events.ContextDestroyedEvent;
import org.craftercms.core.exception.AuthenticationException;
import org.craftercms.core.exception.CrafterException;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.InvalidScopeException;
import org.craftercms.core.exception.InvalidStoreTypeException;
import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.exception.PathNotFoundException;
import org.craftercms.core.exception.RootFolderNotFoundException;
import org.craftercms.core.exception.StoreAccessDeniedException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.exception.XmlFileParseException;
import org.craftercms.core.exception.XmlMergeException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.processors.ItemProcessorResolver;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.ItemFilter;
import org.craftercms.core.service.Tree;
import org.craftercms.core.service.impl.AbstractCachedContentStoreService;
import org.craftercms.core.service.impl.ResourceBasedContent;
import org.craftercms.core.store.ContentStoreAdapter;
import org.craftercms.core.store.ContentStoreAdapterRegistry;
import org.craftercms.core.util.XmlUtils;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.core.util.cache.impl.CachingAwareList;
import org.craftercms.core.xml.mergers.DescriptorMergeStrategy;
import org.craftercms.core.xml.mergers.DescriptorMergeStrategyResolver;
import org.craftercms.core.xml.mergers.DescriptorMerger;
import org.craftercms.core.xml.mergers.MergeableDescriptor;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

public class ContentStoreServiceImpl
extends AbstractCachedContentStoreService
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ContentStoreServiceImpl.class);
    protected ContentStoreAdapterRegistry storeAdapterRegistry;
    protected DescriptorMergeStrategyResolver mergeStrategyResolver;
    protected DescriptorMerger merger;
    protected ItemProcessorResolver processorResolver;
    protected Map<String, Context> contexts;
    protected BlobUrlResolver blobUrlResolver;
    protected BlobStoreResolver blobStoreResolver;
    protected ObjectMapper mapper = new XmlMapper();
    protected ApplicationContext applicationContext;
    protected boolean sourceAttributeEnabled = false;
    protected String sourceAttributeName;
    protected String sourceTypeAttributeName;
    protected String sourceTypeXPath;

    @ConstructorProperties(value={"cacheTemplate", "storeAdapterRegistry", "mergeStrategyResolver", "merger", "processorResolver", "blobUrlResolver", "blobStoreResolver", "sourceAttributeName", "sourceTypeAttributeName", "sourceTypeXPath"})
    public ContentStoreServiceImpl(CacheTemplate cacheTemplate, ContentStoreAdapterRegistry storeAdapterRegistry, DescriptorMergeStrategyResolver mergeStrategyResolver, DescriptorMerger merger, ItemProcessorResolver processorResolver, BlobUrlResolver blobUrlResolver, BlobStoreResolver blobStoreResolver, String sourceAttributeName, String sourceTypeAttributeName, String sourceTypeXPath) {
        super(cacheTemplate);
        this.storeAdapterRegistry = storeAdapterRegistry;
        this.mergeStrategyResolver = mergeStrategyResolver;
        this.merger = merger;
        this.processorResolver = processorResolver;
        this.blobUrlResolver = blobUrlResolver;
        this.blobStoreResolver = blobStoreResolver;
        this.sourceAttributeName = sourceAttributeName;
        this.sourceTypeAttributeName = sourceTypeAttributeName;
        this.sourceTypeXPath = sourceTypeXPath;
        this.contexts = new ConcurrentHashMap<String, Context>();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setSourceAttributeEnabled(boolean sourceAttributeEnabled) {
        this.sourceAttributeEnabled = sourceAttributeEnabled;
    }

    @Override
    public Context getContext(String contextId) {
        return this.contexts.get(contextId);
    }

    @Override
    public Context getContext(String tag, String storeType, String rootFolderPath, boolean mergingOn, boolean cacheOn, int maxAllowedItemsInCache, boolean ignoreHiddenFiles, Map<String, String> configurationVariables) throws InvalidStoreTypeException, RootFolderNotFoundException, StoreException, AuthenticationException {
        String id = this.createContextId(tag, storeType, rootFolderPath, cacheOn, maxAllowedItemsInCache, ignoreHiddenFiles);
        if (!this.contexts.containsKey(id)) {
            ContentStoreAdapter storeAdapter = this.storeAdapterRegistry.get(storeType);
            if (storeAdapter == null) {
                throw new InvalidStoreTypeException("No registered content store adapter for store type " + storeType);
            }
            Context context = storeAdapter.createContext(id, rootFolderPath, mergingOn, cacheOn, maxAllowedItemsInCache, ignoreHiddenFiles, configurationVariables);
            this.cacheTemplate.getCacheService().addScope(context);
            this.applicationContext.publishEvent((ApplicationEvent)new ContextCreatedEvent(context));
            this.contexts.put(id, context);
            return context;
        }
        return this.contexts.get(id);
    }

    @Override
    public boolean validate(Context context) throws StoreException, AuthenticationException {
        return context.getStoreAdapter().validate(context);
    }

    @Override
    public boolean destroyContext(Context context) throws InvalidContextException, StoreException, AuthenticationException {
        if (this.contexts.containsKey(context.getId())) {
            context.getStoreAdapter().destroyContext(context);
            this.applicationContext.publishEvent((ApplicationEvent)new ContextDestroyedEvent(context));
            this.cacheTemplate.getCacheService().removeScope(context);
            this.contexts.remove(context.getId());
            return true;
        }
        return false;
    }

    @Override
    public boolean doExists(Context context, CachingOptions cachingOptions, String url) throws InvalidContextException, PathNotFoundException, StoreException {
        return context.getStoreAdapter().exists(context, cachingOptions, StringUtils.prependIfMissing((String)url, (CharSequence)"/", (CharSequence[])new CharSequence[0]));
    }

    @Override
    public Content findContent(Context context, CachingOptions cachingOptions, String url) throws InvalidContextException, StoreException {
        if (context.getStoreAdapter().exists(context, cachingOptions, url)) {
            return context.getStoreAdapter().findContent(context, cachingOptions, url);
        }
        String blobUrl = this.blobUrlResolver.getBlobUrl(url);
        if (context.getStoreAdapter().exists(context, cachingOptions, blobUrl)) {
            ResourceBasedContent resourceBasedContent;
            block10: {
                Content content = context.getStoreAdapter().findContent(context, cachingOptions, blobUrl);
                InputStream is = content.getInputStream();
                try {
                    Blob blob = (Blob)this.mapper.readValue(is, Blob.class);
                    BlobStore store = this.blobStoreResolver.getById((ConfigurationProvider)new ConfigurationProviderImpl(cachingOptions, context), blob.getStoreId());
                    resourceBasedContent = new ResourceBasedContent(store.getResource(url, blob));
                    if (is == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new StoreException("Error reading blob file at " + blobUrl, e);
                    }
                }
                is.close();
            }
            return resourceBasedContent;
        }
        return null;
    }

    @Override
    public Content getContent(Context context, CachingOptions cachingOptions, String url) throws InvalidScopeException, PathNotFoundException, StoreException {
        Content content = this.findContent(context, cachingOptions, url);
        if (content != null) {
            return content;
        }
        throw new PathNotFoundException("No file found at " + url);
    }

    @Override
    protected Item doFindItem(Context context, CachingOptions cachingOptions, String url, ItemProcessor processor) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        Item item;
        if (!((String)url).startsWith("/")) {
            url = "/" + (String)url;
        }
        if (!context.getStoreAdapter().exists(context, cachingOptions, (String)url)) {
            String blobUrl = this.blobUrlResolver.getBlobUrl((String)url);
            if (context.getStoreAdapter().exists(context, cachingOptions, blobUrl)) {
                Item item2 = new Item();
                item2.setName(FilenameUtils.getName((String)url));
                item2.setUrl((String)url);
                item2.setFolder(false);
                return item2;
            }
        }
        if ((item = context.getStoreAdapter().findItem(context, cachingOptions, (String)url, true)) != null) {
            if ((item = new Item(item)).getDescriptorDom() != null) {
                item = this.doMerging(context, cachingOptions, item);
                item = this.doProcessing(context, cachingOptions, item, processor);
            } else {
                item = this.doProcessing(context, cachingOptions, item, processor);
            }
        }
        return item;
    }

    @Override
    protected List<Item> doFindChildren(Context context, CachingOptions cachingOptions, String url, ItemFilter filter, ItemProcessor processor, boolean flatten) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        if (!((String)url).startsWith("/")) {
            url = "/" + (String)url;
        }
        return this.doFindChildren(context, cachingOptions, (String)url, null, filter, processor, flatten);
    }

    @Override
    protected Tree doFindTree(Context context, CachingOptions cachingOptions, String url, int depth, ItemFilter filter, ItemProcessor processor, boolean flatten) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        Item item;
        if (!((String)url).startsWith("/")) {
            url = "/" + (String)url;
        }
        if ((item = this.findItem(context, cachingOptions, (String)url, processor, flatten)) != null) {
            Tree tree = new Tree(item);
            if (depth == -1 || depth >= 1) {
                CachingAwareList treeChildren;
                if (depth >= 1) {
                    --depth;
                }
                if ((treeChildren = (CachingAwareList)this.doFindChildren(context, cachingOptions, (String)url, depth, filter, processor, flatten)) != null) {
                    tree.setChildren(treeChildren.getActualList());
                }
            }
            return tree;
        }
        return null;
    }

    protected List<Item> doFindChildren(Context context, CachingOptions cachingOptions, String url, Integer depth, ItemFilter filter, ItemProcessor processor, boolean flatten) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        List<Item> children = this.getChildrenInternal(context, cachingOptions, url, processor, flatten);
        if (children != null) {
            if (filter != null && filter.runBeforeProcessing()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Running filter " + String.valueOf(filter) + " before processing for " + url + "...");
                }
                children = this.doFilter(children, filter, true);
            }
            List<Item> processedChildren = new ArrayList<Item>(children.size());
            for (Item child : children) {
                try {
                    Item processedChild = depth != null && child.isFolder() ? this.getTree(context, cachingOptions, child.getUrl(), depth, filter, processor, flatten) : this.getItem(context, cachingOptions, child.getUrl(), processor, flatten);
                    processedChildren.add(processedChild);
                }
                catch (StoreAccessDeniedException e) {
                    logger.warn("Access denied for url '{}'", (Object)child.getUrl());
                    logger.debug("Error getting item for url: '{}'", (Object)child.getUrl(), (Object)e);
                }
            }
            if (filter != null && filter.runAfterProcessing()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Running filter " + String.valueOf(filter) + " after processing for " + url + "...");
                }
                processedChildren = this.doFilter(processedChildren, filter, false);
            }
            processedChildren.sort(CompareByItemNameComparator.instance);
            return new CachingAwareList<Item>(processedChildren);
        }
        return null;
    }

    protected List<Item> getChildrenInternal(Context context, CachingOptions cachingOptions, String url, ItemProcessor processor, boolean flatten) {
        return context.getStoreAdapter().findItems(context, cachingOptions, url);
    }

    protected Item doMerging(Context context, CachingOptions cachingOptions, Item item) throws CrafterException {
        if (context.isMergingOn()) {
            List<MergeableDescriptor> descriptorsToMerge;
            Document mainDescriptorDom;
            String mainDescriptorUrl;
            DescriptorMergeStrategy strategy;
            if (logger.isDebugEnabled()) {
                logger.debug("Doing merge for " + String.valueOf(item) + "...");
            }
            if ((strategy = this.mergeStrategyResolver.getStrategy(mainDescriptorUrl = item.getDescriptorUrl(), mainDescriptorDom = item.getDescriptorDom())) == null) {
                logger.warn("No merge strategy was found for " + mainDescriptorUrl + ". Merging skipped");
                return item;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Merge strategy for " + mainDescriptorUrl + ": " + String.valueOf(strategy));
            }
            if ((descriptorsToMerge = strategy.getDescriptors(context, cachingOptions, mainDescriptorUrl, mainDescriptorDom)) == null) {
                throw new XmlMergeException("There aren't any descriptors to merge for " + mainDescriptorUrl);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Descriptors to merge for " + mainDescriptorUrl + ": " + String.valueOf(descriptorsToMerge));
            }
            ArrayList<Document> documentsToMerge = new ArrayList<Document>(descriptorsToMerge.size());
            ListIterator<MergeableDescriptor> iterator = descriptorsToMerge.listIterator();
            while (iterator.hasNext()) {
                MergeableDescriptor descriptorToMerge = iterator.next();
                String descriptorUrl = descriptorToMerge.getUrl();
                Item descriptorItem = context.getStoreAdapter().findItem(context, cachingOptions, descriptorUrl, true);
                if (descriptorItem != null) {
                    Element root;
                    Document descriptorDom = descriptorItem.getDescriptorDom();
                    if (descriptorDom == null && !descriptorToMerge.isOptional()) {
                        throw new XmlMergeException("Descriptor file " + descriptorUrl + " not found and is marked as required for merging");
                    }
                    if (descriptorDom != null && this.sourceAttributeEnabled && iterator.hasNext() && (root = descriptorDom.getRootElement()) != null) {
                        root.elements().forEach(child -> this.addSourceAttributes(descriptorDom, (Element)child, descriptorUrl));
                    }
                    documentsToMerge.add(descriptorDom);
                    continue;
                }
                if (descriptorToMerge.isOptional()) continue;
                throw new XmlMergeException("Descriptor file " + descriptorUrl + " not found and is marked as required for merging");
            }
            Document mergedDoc = this.merger.merge(documentsToMerge);
            if (logger.isDebugEnabled()) {
                logger.debug("Merged descriptor DOM for " + String.valueOf(item) + ":\n" + XmlUtils.documentToPrettyString(mergedDoc));
            }
            item.setDescriptorDom(mergedDoc);
        }
        return item;
    }

    protected void addSourceAttributes(Document document, Element element, String descriptorUrl) {
        element.addAttribute(this.sourceAttributeName, descriptorUrl);
        element.addAttribute(this.sourceTypeAttributeName, XmlUtils.selectSingleNodeValue((Node)document, this.sourceTypeXPath));
    }

    protected Item doProcessing(Context context, CachingOptions cachingOptions, Item item, ItemProcessor additionalProcessor) throws ItemProcessingException {
        if (logger.isDebugEnabled()) {
            logger.debug("Doing processing for " + String.valueOf(item) + "...");
        }
        if (additionalProcessor == null || !additionalProcessor.isExclusive()) {
            ItemProcessor mainProcessor = this.processorResolver.getProcessor(item);
            if (mainProcessor != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Main processor found for " + String.valueOf(item) + ": " + String.valueOf(mainProcessor));
                }
                item = mainProcessor.process(context, cachingOptions, item);
            } else if (logger.isDebugEnabled()) {
                logger.debug("No main processor was found for " + String.valueOf(item));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Additional processor is exclusive, skipping main processor for {}", (Object)item);
        }
        if (additionalProcessor != null) {
            item = additionalProcessor.process(context, cachingOptions, item);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Processed item: " + String.valueOf(item));
            if (item.getDescriptorDom() != null) {
                logger.debug("Processed descriptor DOM for " + String.valueOf(item) + ":\n" + XmlUtils.documentToPrettyString(item.getDescriptorDom()));
            }
        }
        return item;
    }

    protected List<Item> doFilter(List<Item> items, ItemFilter filter, boolean runningBeforeProcessing) {
        ArrayList<Item> acceptedItems = new ArrayList<Item>();
        ArrayList<Item> rejectedItems = new ArrayList<Item>();
        for (Item item : items) {
            if (filter.accepts(item, acceptedItems, rejectedItems, runningBeforeProcessing)) {
                acceptedItems.add(item);
                continue;
            }
            rejectedItems.add(item);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Items filtered from " + String.valueOf(items) + " by " + String.valueOf(filter) + ": " + String.valueOf(acceptedItems));
        }
        return acceptedItems;
    }

    protected String createContextId(String tag, String storeType, String rootFolderPath, boolean cacheOn, int maxAllowedItemsInCache, boolean ignoreHiddenFiles) {
        String unHashedId = "tag='" + (tag != null ? tag : "") + "', storeType='" + storeType + "', rootFolderPath='" + rootFolderPath + "', cacheOn=" + cacheOn + ", maxAllowedItemsInCache=" + maxAllowedItemsInCache + ", ignoreHiddenFiles=" + ignoreHiddenFiles;
        return DigestUtils.md5Hex((String)unHashedId);
    }

    private class ConfigurationProviderImpl
    implements ConfigurationProvider {
        private final CachingOptions cachingOptions;
        private final Context context;

        public ConfigurationProviderImpl(CachingOptions cachingOptions, Context context) {
            this.cachingOptions = cachingOptions;
            this.context = context;
        }

        public boolean configExists(String path) {
            return ContentStoreServiceImpl.this.exists(this.context, this.cachingOptions, path);
        }

        public InputStream getConfig(String path) throws IOException {
            return ContentStoreServiceImpl.this.getContent(this.context, this.cachingOptions, path).getInputStream();
        }

        public Map<String, String> getLookupVariables() {
            return this.context.getConfigLookupVariables();
        }
    }

    private static class CompareByItemNameComparator
    implements Comparator<Item> {
        public static final CompareByItemNameComparator instance = new CompareByItemNameComparator();

        private CompareByItemNameComparator() {
        }

        @Override
        public int compare(Item item1, Item item2) {
            return item1.getName().compareTo(item2.getName());
        }
    }
}

