/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.service.impl;

import java.util.List;
import org.craftercms.commons.lang.Callback;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.exception.PathNotFoundException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.exception.XmlFileParseException;
import org.craftercms.core.exception.XmlMergeException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.processors.impl.ItemProcessorPipeline;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.ItemFilter;
import org.craftercms.core.service.Tree;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.core.util.cache.impl.CachingAwareList;

public abstract class AbstractCachedContentStoreService
implements ContentStoreService {
    public static final String CONST_KEY_ELEM_ITEM = "contentStoreService.item";
    public static final String CONST_KEY_ELEM_CHILDREN = "contentStoreService.children";
    public static final String CONST_KEY_ELEM_TREE = "contentStoreService.tree";
    public static final String CONST_KEY_ELEM_EXISTS = "contentStoreService.exists";
    protected CacheTemplate cacheTemplate;
    protected CachingOptions defaultCachingOptions;
    protected ItemProcessor flatteningProcessor;

    public void setDefaultCachingOptions(CachingOptions defaultCachingOptions) {
        this.defaultCachingOptions = defaultCachingOptions;
    }

    public void setFlatteningProcessor(ItemProcessor flatteningProcessor) {
        this.flatteningProcessor = flatteningProcessor;
    }

    public AbstractCachedContentStoreService(CacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    @Override
    public boolean exists(Context context, String url) throws InvalidContextException, PathNotFoundException, StoreException {
        return this.exists(context, null, url);
    }

    @Override
    public boolean exists(final Context context, CachingOptions cachingOptions, final String url) throws InvalidContextException, PathNotFoundException, StoreException {
        final CachingOptions actualCachingOptions = cachingOptions != null ? cachingOptions : this.defaultCachingOptions;
        return this.cacheTemplate.getObject(context, actualCachingOptions, new Callback<Boolean>(){

            public Boolean execute() {
                return AbstractCachedContentStoreService.this.doExists(context, actualCachingOptions, url);
            }

            public String toString() {
                return String.format(AbstractCachedContentStoreService.this.getClass().getName() + ".exists(%s, %s)", context, url);
            }
        }, url, CONST_KEY_ELEM_EXISTS);
    }

    protected ItemProcessor getProcessor(ItemProcessor processor, boolean flatten) {
        if (!flatten) {
            return processor;
        }
        if (processor == null) {
            return this.flatteningProcessor;
        }
        if (processor.isExclusive()) {
            return processor;
        }
        return new ItemProcessorPipeline(this.flatteningProcessor, processor);
    }

    @Override
    public Item findItem(final Context context, CachingOptions cachingOptions, final String url, ItemProcessor processor, boolean flatten) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        final CachingOptions actualCachingOptions = cachingOptions != null ? cachingOptions : this.defaultCachingOptions;
        final ItemProcessor actualProcessor = this.getProcessor(processor, flatten);
        return this.cacheTemplate.getObject(context, actualCachingOptions, new Callback<Item>(){

            public Item execute() {
                return AbstractCachedContentStoreService.this.doFindItem(context, actualCachingOptions, url, actualProcessor);
            }

            public String toString() {
                return String.format(AbstractCachedContentStoreService.this.getClass().getName() + ".getItem(%s, %s, %s)", context, url, actualProcessor);
            }
        }, url, actualProcessor, CONST_KEY_ELEM_ITEM);
    }

    @Override
    public Item getItem(Context context, CachingOptions cachingOptions, String url, ItemProcessor processor, boolean flatten) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        Item item = this.findItem(context, cachingOptions, url, processor, flatten);
        if (item != null) {
            return item;
        }
        throw new PathNotFoundException("No item found at " + url);
    }

    @Override
    public List<Item> findChildren(final Context context, CachingOptions cachingOptions, final String url, final ItemFilter filter, ItemProcessor processor, final boolean flatten) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        final CachingOptions actualCachingOptions = cachingOptions != null ? cachingOptions : this.defaultCachingOptions;
        final ItemProcessor actualProcessor = this.getProcessor(processor, flatten);
        return this.cacheTemplate.getObject(context, actualCachingOptions, new Callback<List<Item>>(){

            public List<Item> execute() {
                List<Item> children = AbstractCachedContentStoreService.this.doFindChildren(context, actualCachingOptions, url, filter, actualProcessor, flatten);
                if (children != null) {
                    if (children instanceof CachingAwareList) {
                        return children;
                    }
                    return new CachingAwareList<Item>(children);
                }
                return null;
            }

            public String toString() {
                return String.format(AbstractCachedContentStoreService.this.getClass().getName() + ".getChildren(%s, %s, %s, %s)", context, url, filter, actualProcessor);
            }
        }, url, filter, actualProcessor, CONST_KEY_ELEM_CHILDREN);
    }

    @Override
    public List<Item> getChildren(Context context, CachingOptions cachingOptions, String url, ItemFilter filter, ItemProcessor processor, boolean flatten) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        List<Item> children = this.findChildren(context, cachingOptions, url, filter, processor, flatten);
        if (children != null) {
            return children;
        }
        throw new PathNotFoundException("No folder found at " + url);
    }

    @Override
    public Tree findTree(final Context context, CachingOptions cachingOptions, final String url, final int depth, final ItemFilter filter, ItemProcessor processor, final boolean flatten) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        final CachingOptions actualCachingOptions = cachingOptions != null ? cachingOptions : this.defaultCachingOptions;
        final ItemProcessor actualProcessor = this.getProcessor(processor, flatten);
        return this.cacheTemplate.getObject(context, actualCachingOptions, new Callback<Tree>(){

            public Tree execute() {
                return AbstractCachedContentStoreService.this.doFindTree(context, actualCachingOptions, url, depth, filter, actualProcessor, flatten);
            }

            public String toString() {
                return String.format(AbstractCachedContentStoreService.this.getClass().getName() + ".getTree(%s, %s, %d, %s, %s)", context, url, depth, filter, actualProcessor);
            }
        }, url, depth, filter, actualProcessor, CONST_KEY_ELEM_TREE);
    }

    @Override
    public Tree getTree(Context context, CachingOptions cachingOptions, String url, int depth, ItemFilter filter, ItemProcessor processor, boolean flatten) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        Tree tree = this.findTree(context, cachingOptions, url, depth, filter, processor, flatten);
        if (tree != null) {
            return tree;
        }
        throw new PathNotFoundException("No folder found at " + url);
    }

    protected abstract boolean doExists(Context var1, CachingOptions var2, String var3) throws InvalidContextException, PathNotFoundException, StoreException;

    protected abstract Item doFindItem(Context var1, CachingOptions var2, String var3, ItemProcessor var4) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    protected abstract List<Item> doFindChildren(Context var1, CachingOptions var2, String var3, ItemFilter var4, ItemProcessor var5, boolean var6) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    protected abstract Tree doFindTree(Context var1, CachingOptions var2, String var3, int var4, ItemFilter var5, ItemProcessor var6, boolean var7) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;
}

