/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.service;

import java.util.List;
import java.util.Map;
import org.craftercms.core.exception.AuthenticationException;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.InvalidScopeException;
import org.craftercms.core.exception.InvalidStoreTypeException;
import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.exception.PathNotFoundException;
import org.craftercms.core.exception.RootFolderNotFoundException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.exception.XmlFileParseException;
import org.craftercms.core.exception.XmlMergeException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.ItemFilter;
import org.craftercms.core.service.Tree;

public interface ContentStoreService {
    public static final int UNLIMITED_TREE_DEPTH = -1;
    public static final int TREE_DEPTH_HARD_LIMIT = 20;

    public Context getContext(String var1);

    public Context getContext(String var1, String var2, String var3, boolean var4, boolean var5, int var6, boolean var7, Map<String, String> var8) throws InvalidStoreTypeException, RootFolderNotFoundException, StoreException, AuthenticationException;

    public boolean validate(Context var1) throws StoreException, AuthenticationException;

    public boolean destroyContext(Context var1) throws StoreException, AuthenticationException;

    public boolean exists(Context var1, CachingOptions var2, String var3) throws InvalidContextException, PathNotFoundException, StoreException;

    public boolean exists(Context var1, String var2) throws InvalidContextException, PathNotFoundException, StoreException;

    default public Content findContent(Context context, String url) throws InvalidContextException, StoreException {
        return this.findContent(context, null, url);
    }

    public Content findContent(Context var1, CachingOptions var2, String var3) throws InvalidContextException, StoreException;

    default public Content getContent(Context context, String url) throws InvalidScopeException, PathNotFoundException, StoreException {
        return this.getContent(context, null, url);
    }

    public Content getContent(Context var1, CachingOptions var2, String var3) throws InvalidContextException, PathNotFoundException, StoreException;

    default public Item findItem(Context context, String url) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.findItem(context, null, url, null, false);
    }

    default public Item findItem(Context context, CachingOptions cachingOptions, String url, ItemProcessor processor) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.findItem(context, cachingOptions, url, processor, false);
    }

    public Item findItem(Context var1, CachingOptions var2, String var3, ItemProcessor var4, boolean var5) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    default public Item getItem(Context context, String url) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getItem(context, null, url, null, false);
    }

    default public Item getItem(Context context, CachingOptions cachingOptions, String url, ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getItem(context, cachingOptions, url, processor, false);
    }

    public Item getItem(Context var1, CachingOptions var2, String var3, ItemProcessor var4, boolean var5) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    default public List<Item> findChildren(Context context, String url) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.findChildren(context, null, url, null, null, false);
    }

    default public List<Item> findChildren(Context context, CachingOptions cachingOptions, String url, ItemFilter filter, ItemProcessor processor) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.findChildren(context, cachingOptions, url, filter, processor, false);
    }

    public List<Item> findChildren(Context var1, CachingOptions var2, String var3, ItemFilter var4, ItemProcessor var5, boolean var6) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    default public List<Item> getChildren(Context context, String url) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getChildren(context, null, url, null, null, false);
    }

    default public List<Item> getChildren(Context context, CachingOptions cachingOptions, String url, ItemFilter filter, ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getChildren(context, cachingOptions, url, filter, processor, false);
    }

    public List<Item> getChildren(Context var1, CachingOptions var2, String var3, ItemFilter var4, ItemProcessor var5, boolean var6) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    default public Tree findTree(Context context, String url) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.findTree(context, null, url, -1, null, null, false);
    }

    default public Tree getTree(Context context, String url) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getTree(context, null, url, -1, null, null, false);
    }

    default public Tree findTree(Context context, String url, int depth) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.findTree(context, null, url, depth, null, null, false);
    }

    default public Tree findTree(Context context, CachingOptions cachingOptions, String url, int depth, ItemFilter filter, ItemProcessor processor) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.findTree(context, cachingOptions, url, depth, filter, processor, false);
    }

    public Tree findTree(Context var1, CachingOptions var2, String var3, int var4, ItemFilter var5, ItemProcessor var6, boolean var7) throws InvalidContextException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    default public Tree getTree(Context context, String url, int depth) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getTree(context, null, url, depth, null, null, false);
    }

    default public Tree getTree(Context context, CachingOptions cachingOptions, String url, int depth, ItemFilter filter, ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getTree(context, cachingOptions, url, depth, filter, processor, false);
    }

    public Tree getTree(Context var1, CachingOptions var2, String var3, int var4, ItemFilter var5, ItemProcessor var6, boolean var7) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;
}

