/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.controller.rest;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.exceptions.InvalidManagementTokenException;
import org.craftercms.core.controller.rest.RestControllerBase;
import org.craftercms.core.exception.CacheException;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.core.util.cache.CacheTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${crafter.core.rest.base.uri}/cache"})
public class CacheRestController
extends RestControllerBase {
    private static final Log logger = LogFactory.getLog(CacheRestController.class);
    public static final String URL_ROOT = "/cache";
    public static final String URL_CLEAR_ALL_SCOPES = "/clear_all";
    public static final String URL_CLEAR_SCOPE = "/clear";
    public static final String REQUEST_PARAM_CONTEXT_ID = "contextId";
    private CacheTemplate cacheTemplate;
    private ContentStoreService storeService;
    private String authorizationToken;

    public CacheRestController(CacheTemplate cacheTemplate, ContentStoreService storeService, String authorizationToken) {
        this.cacheTemplate = cacheTemplate;
        this.storeService = storeService;
        this.authorizationToken = authorizationToken;
    }

    @RequestMapping(value={"/clear_all"}, method={RequestMethod.GET})
    public Map<String, Object> clearAllScopes(@RequestParam String token) throws CacheException, InvalidManagementTokenException {
        this.validateToken(token);
        this.cacheTemplate.getCacheService().clearAll();
        if (logger.isInfoEnabled()) {
            logger.info((Object)"[CACHE] All scopes have been cleared");
        }
        return CacheRestController.createResponseMessage("All cache scopes have been cleared");
    }

    @RequestMapping(value={"/clear"}, method={RequestMethod.GET})
    public Map<String, Object> clearScope(@RequestParam(value="contextId") String contextId, @RequestParam String token) throws InvalidContextException, CacheException, InvalidManagementTokenException {
        this.validateToken(token);
        Context context = this.storeService.getContext(contextId);
        if (context == null) {
            throw new InvalidContextException("No context found for ID " + contextId);
        }
        this.cacheTemplate.getCacheService().clearScope(context);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[CACHE] Scope for context " + String.valueOf(context) + " has been cleared"));
        }
        return CacheRestController.createResponseMessage("Cache scope for context '" + contextId + "' has been cleared");
    }

    protected void validateToken(String token) throws InvalidManagementTokenException {
        if (!StringUtils.equals((CharSequence)token, (CharSequence)this.authorizationToken)) {
            throw new InvalidManagementTokenException("Management authorization failed, invalid token.");
        }
    }
}

