/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.cache.impl.store.guava;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.craftercms.core.cache.CacheItem;
import org.craftercms.core.cache.CacheStatistics;
import org.craftercms.core.cache.impl.CacheStoreAdapter;
import org.craftercms.core.cache.impl.store.guava.GuavaCacheStatistics;
import org.springframework.beans.factory.DisposableBean;

public class GuavaCacheStoreAdapter
implements CacheStoreAdapter,
DisposableBean {
    protected final Map<String, Cache<Object, Object>> caches = new ConcurrentHashMap<String, Cache<Object, Object>>();

    public void destroy() {
        this.caches.forEach((scope, cache) -> {
            cache.invalidateAll();
            cache.cleanUp();
        });
    }

    @Override
    public boolean hasScope(String scope) {
        return this.caches.containsKey(scope);
    }

    @Override
    public Collection<String> getScopes() {
        return this.caches.keySet();
    }

    @Override
    public void addScope(String scope, int maxItemsInMemory) {
        this.caches.put(scope, (Cache<Object, Object>)CacheBuilder.newBuilder().recordStats().maximumSize((long)maxItemsInMemory).build());
    }

    @Override
    public void removeScope(String scope) {
        this.caches.remove(scope);
    }

    @Override
    public int getSize(String scope) {
        return (int)this.caches.get(scope).size();
    }

    @Override
    public Collection<Object> getKeys(String scope) {
        return this.caches.get(scope).asMap().keySet();
    }

    @Override
    public boolean hasKey(String scope, Object key) {
        return this.caches.get(scope).asMap().containsKey(key);
    }

    @Override
    public CacheItem get(String scope, Object key) {
        Object element = this.caches.get(scope).getIfPresent(key);
        if (element != null) {
            return (CacheItem)element;
        }
        return null;
    }

    @Override
    public void put(CacheItem item) {
        this.caches.get(item.getScope()).put(item.getKey(), (Object)item);
    }

    @Override
    public boolean remove(String scope, Object key) {
        this.caches.get(scope).invalidate(key);
        return true;
    }

    @Override
    public void clearAll() {
        this.caches.values().forEach(Cache::invalidateAll);
    }

    @Override
    public void clearScope(String scope) {
        this.caches.get(scope).invalidateAll();
    }

    @Override
    public CacheStatistics getStatistics(String scope) {
        return new GuavaCacheStatistics(this.caches.get(scope));
    }
}

