/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.cache.impl;

import java.util.Arrays;
import org.craftercms.core.cache.CacheItem;
import org.craftercms.core.cache.CacheLoader;

public class CacheItemImpl
implements CacheItem {
    protected final String scope;
    protected final long ticksAtCreation;
    protected final Object key;
    protected final Object value;
    protected final long ticksToExpire;
    protected final long ticksToRefresh;
    protected final CacheLoader loader;
    protected final Object[] loaderParams;

    public CacheItemImpl(String scope, long ticksAtCreation, Object key, Object value, long ticksToExpire, long ticksToRefresh, CacheLoader loader, Object[] loaderParams) {
        this.scope = scope;
        this.ticksAtCreation = ticksAtCreation;
        this.key = key;
        this.value = value;
        this.ticksToExpire = ticksToExpire;
        this.ticksToRefresh = ticksToRefresh;
        this.loader = loader;
        this.loaderParams = loaderParams;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public long getTicksAtCreation() {
        return this.ticksAtCreation;
    }

    @Override
    public long getTicksToExpire() {
        return this.ticksToExpire;
    }

    @Override
    public long getTicksToRefresh() {
        return this.ticksToRefresh;
    }

    @Override
    public CacheLoader getLoader() {
        return this.loader;
    }

    @Override
    public Object[] getLoaderParams() {
        return this.loaderParams;
    }

    @Override
    public boolean isExpired(long currentTicks) {
        return this.ticksToExpire != 0L && currentTicks >= this.ticksAtCreation + this.ticksToExpire;
    }

    @Override
    public boolean needsRefresh(long currentTicks) {
        return this.ticksToRefresh != 0L && currentTicks >= this.ticksAtCreation + this.ticksToRefresh;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheItemImpl item = (CacheItemImpl)o;
        if (!this.key.equals(item.key)) {
            return false;
        }
        return this.scope.equals(item.scope);
    }

    public int hashCode() {
        int result = this.scope.hashCode();
        result = 31 * result + this.key.hashCode();
        return result;
    }

    public String toString() {
        return "CacheItemImpl[scope='" + this.scope + "', ticksAtCreation=" + this.ticksAtCreation + ", key=" + String.valueOf(this.key) + ", value=" + String.valueOf(this.value) + ", ticksToExpire=" + this.ticksToExpire + ", ticksToRefresh=" + this.ticksToRefresh + ", loader=" + String.valueOf(this.loader) + ", loaderParams=" + String.valueOf(this.loaderParams == null ? null : Arrays.asList(this.loaderParams)) + "]";
    }
}

