/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.audit;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.craftercms.commons.audit.AuditModel;
import org.craftercms.commons.audit.AuditService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditReaper {
    protected AuditService<? extends AuditModel> auditService;
    protected int maxAuditAllowedDays;
    private Logger log = LoggerFactory.getLogger(AuditReaper.class);

    public void scythe() {
        this.log.debug("Starting Audit Cleanup");
        if (this.maxAuditAllowedDays >= 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, this.maxAuditAllowedDays * -1);
            Date since = new Date(calendar.getTimeInMillis());
            List<? extends AuditModel> toDelete = this.auditService.getAuditLogs(since, new Date());
            if (toDelete != null) {
                List<String> idstoDel = this.getIdList(toDelete);
                this.log.info("Deleting {} audit entries ", (Object)idstoDel.size());
                if (toDelete != null) {
                    this.auditService.deleteAudits(idstoDel);
                }
                this.log.info("Going to sleep now");
            } else {
                this.log.info("AuditService return null when ask to give audits with in this range {} {}", (Object)since, (Object)new Date());
            }
        } else {
            this.log.info("Skipping scythe maxAuditAllowedDays is set to infinity");
        }
    }

    private List<String> getIdList(List<? extends AuditModel> toDelete) {
        ArrayList<String> ids = new ArrayList<String>(toDelete.size());
        for (AuditModel auditModel : toDelete) {
            ids.add(auditModel.getId());
        }
        return ids;
    }

    public void setAuditService(AuditService<?> auditService) {
        this.auditService = auditService;
    }

    public void setMaxAuditAllowedDays(int maxAuditAllowedDays) {
        this.maxAuditAllowedDays = maxAuditAllowedDays;
    }
}

