/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.testwriter.java;

import org.cornutum.tcases.io.IndentedWriter;
import org.cornutum.tcases.openapi.resolver.ApiKeyDef;
import org.cornutum.tcases.openapi.resolver.AuthDef;
import org.cornutum.tcases.openapi.resolver.AuthDefVisitor;
import org.cornutum.tcases.openapi.resolver.HttpBasicDef;
import org.cornutum.tcases.openapi.resolver.HttpBearerDef;

public final class TestCaseWriterUtils {
    private TestCaseWriterUtils() {
    }

    public static void writeStatusCodeMatcherDef(String testName, IndentedWriter targetWriter, Depends dependencies) {
        targetWriter.println();
        targetWriter.println("private static Matcher<Integer> isSuccess() {");
        targetWriter.indent();
        targetWriter.println("return allOf( greaterThanOrEqualTo(200), lessThan(300));");
        targetWriter.unindent();
        targetWriter.println("}");
        targetWriter.println();
        targetWriter.println("private static Matcher<Integer> isBadRequest() {");
        targetWriter.indent();
        targetWriter.println("return allOf( greaterThanOrEqualTo(400), lessThan(500));");
        targetWriter.unindent();
        targetWriter.println("}");
        if (dependencies.dependsAuth()) {
            targetWriter.println();
            targetWriter.println("private static Matcher<Integer> isUnauthorized() {");
            targetWriter.indent();
            targetWriter.println("return is(401);");
            targetWriter.unindent();
            targetWriter.println("}");
        }
    }

    public static void writeTestServerDef(String testName, IndentedWriter targetWriter, Depends dependencies) {
        if (dependencies.dependsServer()) {
            targetWriter.println();
            targetWriter.println("private static String forTestServer() {");
            targetWriter.indent();
            targetWriter.println("return forTestServer( null);");
            targetWriter.unindent();
            targetWriter.println("}");
        }
        targetWriter.println();
        targetWriter.println("private static String forTestServer( String defaultUri) {");
        targetWriter.indent();
        targetWriter.println("String testServer = tcasesApiServer();");
        targetWriter.println("return");
        targetWriter.indent();
        targetWriter.println("defaultUri == null || !testServer.isEmpty()");
        targetWriter.println("? testServer");
        targetWriter.println(": defaultUri;");
        targetWriter.unindent();
        targetWriter.unindent();
        targetWriter.println("}");
        targetWriter.println();
        targetWriter.println("private static String tcasesApiServer() {");
        targetWriter.indent();
        targetWriter.println("String uri = System.getProperty( \"tcasesApiServer\");");
        targetWriter.println("return uri == null? \"\" : uri.trim();");
        targetWriter.unindent();
        targetWriter.println("}");
    }

    public static void writeAuthCredentialsDef(String testName, IndentedWriter targetWriter, Depends dependencies) {
        if (dependencies.dependsApiKey()) {
            targetWriter.println();
            targetWriter.println("private String tcasesApiKey() {");
            targetWriter.indent();
            targetWriter.println("String apiKey = System.getProperty( \"tcasesApiKey\");");
            targetWriter.println("return apiKey == null? \"\" : apiKey;");
            targetWriter.unindent();
            targetWriter.println("}");
        }
        if (dependencies.dependsHttpBearer()) {
            targetWriter.println();
            targetWriter.println("private String tcasesApiBearer() {");
            targetWriter.indent();
            targetWriter.println("String bearer = System.getProperty( \"tcasesApiBearer\");");
            targetWriter.println("return bearer == null? \"\" : bearer;");
            targetWriter.unindent();
            targetWriter.println("}");
            targetWriter.println();
            targetWriter.println("private String tcasesApiBearerCredentials() {");
            targetWriter.indent();
            targetWriter.println("return String.format( \"Bearer %s\", asToken64( tcasesApiBearer()));");
            targetWriter.unindent();
            targetWriter.println("}");
        }
        if (dependencies.dependsHttpBasic()) {
            targetWriter.println();
            targetWriter.println("private String tcasesApiUser() {");
            targetWriter.indent();
            targetWriter.println("String user = System.getProperty( \"tcasesApiUser\");");
            targetWriter.println("return user == null? \"\" : user;");
            targetWriter.unindent();
            targetWriter.println("}");
            targetWriter.println();
            targetWriter.println("private String tcasesApiPassword() {");
            targetWriter.indent();
            targetWriter.println("String password = System.getProperty( \"tcasesApiPassword\");");
            targetWriter.println("return password == null? \"\" : password;");
            targetWriter.unindent();
            targetWriter.println("}");
            targetWriter.println();
            targetWriter.println("private String tcasesApiBasicCredentials() {");
            targetWriter.indent();
            targetWriter.println("return String.format( \"Basic %s\", asToken64( String.format( \"%s:%s\", tcasesApiUser(), tcasesApiPassword())));");
            targetWriter.unindent();
            targetWriter.println("}");
        }
        if (dependencies.dependsAuthHttp()) {
            targetWriter.println();
            targetWriter.println("private String asToken64( String value) {");
            targetWriter.indent();
            targetWriter.println("try {");
            targetWriter.indent();
            targetWriter.println("return java.util.Base64.getEncoder().encodeToString( value.getBytes( \"UTF-8\"));");
            targetWriter.unindent();
            targetWriter.println("}");
            targetWriter.println("catch( Exception e) {");
            targetWriter.indent();
            targetWriter.println("    throw new IllegalArgumentException( String.format( \"Can't get Base64 token for value=%s\", value), e);");
            targetWriter.unindent();
            targetWriter.println("}");
            targetWriter.unindent();
            targetWriter.println("}");
        }
    }

    public static String headerValueOf(AuthDef authDef) {
        return HeaderVisitor.valueOf(authDef);
    }

    public static class Depends {
        private boolean dependsServer_;
        private int dependsAuth_;
        private int dependsAuthHttp_;
        private boolean dependsApiKey_;
        private boolean dependsHttpBasic_;
        private boolean dependsHttpBearer_;

        public void setDependsServer() {
            this.dependsServer_ = true;
        }

        public boolean dependsServer() {
            return this.dependsServer_;
        }

        public boolean dependsAuth() {
            return this.dependsAuth_ > 0;
        }

        public boolean dependsAuthHttp() {
            return this.dependsAuthHttp_ > 0;
        }

        public void setDependsApiKey() {
            ++this.dependsAuth_;
            this.dependsApiKey_ = true;
        }

        public boolean dependsApiKey() {
            return this.dependsApiKey_;
        }

        public void setDependsHttpBasic() {
            ++this.dependsAuth_;
            ++this.dependsAuthHttp_;
            this.dependsHttpBasic_ = true;
        }

        public boolean dependsHttpBasic() {
            return this.dependsHttpBasic_;
        }

        public void setDependsHttpBearer() {
            ++this.dependsAuth_;
            ++this.dependsAuthHttp_;
            this.dependsHttpBearer_ = true;
        }

        public boolean dependsHttpBearer() {
            return this.dependsHttpBearer_;
        }
    }

    private static class HeaderVisitor
    implements AuthDefVisitor {
        private String value_;

        private HeaderVisitor() {
        }

        private static String valueOf(AuthDef authDef) {
            HeaderVisitor visitor = new HeaderVisitor();
            authDef.accept(visitor);
            return visitor.value_;
        }

        @Override
        public void visit(ApiKeyDef authDef) {
            this.value_ = "tcasesApiKey()";
        }

        @Override
        public void visit(HttpBasicDef authDef) {
            this.value_ = "tcasesApiBasicCredentials()";
        }

        @Override
        public void visit(HttpBearerDef authDef) {
            this.value_ = "tcasesApiBearerCredentials()";
        }
    }
}

