/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.testwriter.encoder;

import java.net.URI;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class UriEncoder {
    private final Component component_;
    private static final Pattern uriPattern_ = Pattern.compile("http://host/([^?]*)\\?(.*)");

    protected UriEncoder(Component component) {
        this.component_ = component;
    }

    public Component getComponent() {
        return this.component_;
    }

    protected String uriEncoded(String value) {
        return UriEncoder.uriEncoded(this.getComponent(), value);
    }

    public static String uriEncoded(Component component, String value) {
        String encoded;
        switch (Optional.ofNullable(component).filter(c -> value != null).orElse(Component.NONE)) {
            case QUERY: {
                encoded = UriEncoder.uriMatcher(null, value).group(2).replaceAll("\\?", "%3F").replaceAll("=", "%3D").replaceAll("\\&", "%26");
                break;
            }
            case PATH: {
                encoded = UriEncoder.uriMatcher(value, null).group(1);
                break;
            }
            case NONE: {
                encoded = value;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown component=%s", new Object[]{component}));
            }
        }
        return encoded;
    }

    private static Matcher uriMatcher(String path, String query) {
        try {
            String uri = new URI("http", null, "host", -1, "/" + Optional.ofNullable(path).orElse("path"), Optional.ofNullable(query).orElse("query"), null).toASCIIString();
            Matcher matcher = uriPattern_.matcher(uri);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(String.format("Can't recognize uri=%s", uri));
            }
            return matcher;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Can't encode path='%s', query='%s'", path, query), e);
        }
    }

    public static enum Component {
        NONE,
        PATH,
        QUERY;

    }
}

