/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.testwriter.encoder;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cornutum.tcases.openapi.resolver.ArrayValue;
import org.cornutum.tcases.openapi.resolver.Base64Domain;
import org.cornutum.tcases.openapi.resolver.BinaryValue;
import org.cornutum.tcases.openapi.resolver.BooleanValue;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.DataValueVisitor;
import org.cornutum.tcases.openapi.resolver.DecimalValue;
import org.cornutum.tcases.openapi.resolver.IntegerValue;
import org.cornutum.tcases.openapi.resolver.LongValue;
import org.cornutum.tcases.openapi.resolver.NullValue;
import org.cornutum.tcases.openapi.resolver.ObjectValue;
import org.cornutum.tcases.openapi.resolver.ParamData;
import org.cornutum.tcases.openapi.resolver.StringValue;
import org.cornutum.tcases.openapi.testwriter.encoder.SimpleValueEncoder;
import org.cornutum.tcases.openapi.testwriter.encoder.UriEncoder;

public class MatrixValueEncoder
extends UriEncoder
implements DataValueVisitor {
    private final String name_;
    private final boolean exploded_;
    private final DataValue<?> value_;
    private String encoded_;

    private MatrixValueEncoder(String name, DataValue<?> value, boolean exploded, UriEncoder.Component component) {
        super(component);
        this.name_ = name;
        this.value_ = value;
        this.exploded_ = exploded;
    }

    public static String encode(ParamData param, UriEncoder.Component component) {
        return MatrixValueEncoder.encode(param.getName(), param.getValue(), param.isExploded(), component);
    }

    public static String encode(String name, DataValue<?> value, boolean exploded, UriEncoder.Component component) {
        return new MatrixValueEncoder(name, value, exploded, component).accepted();
    }

    private String accepted() {
        return Optional.ofNullable(this.value_).map(value -> {
            value.accept(this);
            return this.encoded_;
        }).orElse("");
    }

    private String matrixParamOf(DataValue<?> value) {
        return this.matrixParamOf(Objects.toString(value.getValue(), ""));
    }

    private String matrixParamOf(String value) {
        return this.matrixParamOf(this.name_, value);
    }

    private String matrixParamOf(String name, String value) {
        return value.isEmpty() ? this.matrixOf(this.uriEncoded(name)) : this.matrixOf(String.format("%s=%s", this.uriEncoded(name), this.uriEncoded(value)));
    }

    private String matrixOf(String value) {
        return String.format(";%s", value);
    }

    @Override
    public void visit(ArrayValue<?> data) {
        this.encoded_ = ((List)data.getValue()).isEmpty() ? this.matrixParamOf("") : (this.exploded_ ? ((List)data.getValue()).stream().map(item -> SimpleValueEncoder.encode(item, UriEncoder.Component.NONE)).map(this::matrixParamOf).collect(Collectors.joining()) : this.matrixParamOf(SimpleValueEncoder.encode(data, UriEncoder.Component.NONE)));
    }

    @Override
    public void visit(BinaryValue data) {
        this.encoded_ = this.matrixParamOf(Base64Domain.encoded((byte[])data.getValue()));
    }

    @Override
    public void visit(BooleanValue data) {
        this.encoded_ = this.matrixParamOf(data);
    }

    @Override
    public void visit(DecimalValue data) {
        this.encoded_ = this.matrixParamOf(data);
    }

    @Override
    public void visit(IntegerValue data) {
        this.encoded_ = this.matrixParamOf(data);
    }

    @Override
    public void visit(LongValue data) {
        this.encoded_ = this.matrixParamOf(data);
    }

    @Override
    public void visit(NullValue data) {
        this.encoded_ = "";
    }

    @Override
    public void visit(ObjectValue data) {
        this.encoded_ = this.exploded_ ? ((Map)data.getValue()).entrySet().stream().map(entry -> this.matrixParamOf((String)entry.getKey(), SimpleValueEncoder.encode((DataValue)entry.getValue(), UriEncoder.Component.NONE))).collect(Collectors.joining()) : this.matrixParamOf(SimpleValueEncoder.encode(data, UriEncoder.Component.NONE));
    }

    @Override
    public void visit(StringValue data) {
        this.encoded_ = this.matrixParamOf(data);
    }
}

