/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.testwriter.encoder;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cornutum.tcases.openapi.resolver.ArrayValue;
import org.cornutum.tcases.openapi.resolver.Base64Domain;
import org.cornutum.tcases.openapi.resolver.BinaryValue;
import org.cornutum.tcases.openapi.resolver.BooleanValue;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.DataValueVisitor;
import org.cornutum.tcases.openapi.resolver.DecimalValue;
import org.cornutum.tcases.openapi.resolver.IntegerValue;
import org.cornutum.tcases.openapi.resolver.LongValue;
import org.cornutum.tcases.openapi.resolver.NullValue;
import org.cornutum.tcases.openapi.resolver.ObjectValue;
import org.cornutum.tcases.openapi.resolver.ParamData;
import org.cornutum.tcases.openapi.resolver.StringValue;
import org.cornutum.tcases.openapi.testwriter.encoder.SimpleValueEncoder;
import org.cornutum.tcases.openapi.testwriter.encoder.UriEncoder;

public class LabelValueEncoder
extends UriEncoder
implements DataValueVisitor {
    private final boolean exploded_;
    private final DataValue<?> value_;
    private String encoded_;

    private LabelValueEncoder(DataValue<?> value, boolean exploded, UriEncoder.Component component) {
        super(component);
        this.value_ = value;
        this.exploded_ = exploded;
    }

    public static String encode(ParamData param, UriEncoder.Component component) {
        return LabelValueEncoder.encode(param.getValue(), param.isExploded(), component);
    }

    public static String encode(DataValue<?> value, boolean exploded, UriEncoder.Component component) {
        return new LabelValueEncoder(value, exploded, component).accepted();
    }

    private String accepted() {
        return Optional.ofNullable(this.value_).map(value -> {
            value.accept(this);
            return this.encoded_;
        }).orElse("");
    }

    private String labelOf(DataValue<?> value) {
        return this.labelOf(this.uriEncoded(Objects.toString(value.getValue(), "")));
    }

    private String labelOf(String value) {
        return String.format(".%s", value);
    }

    @Override
    public void visit(ArrayValue<?> data) {
        this.encoded_ = ((List)data.getValue()).stream().map(item -> SimpleValueEncoder.encode(item, this.getComponent())).map(this::labelOf).collect(Collectors.joining());
    }

    @Override
    public void visit(BinaryValue data) {
        this.encoded_ = this.labelOf(Base64Domain.encoded((byte[])data.getValue()));
    }

    @Override
    public void visit(BooleanValue data) {
        this.encoded_ = this.labelOf(data);
    }

    @Override
    public void visit(DecimalValue data) {
        this.encoded_ = this.labelOf(data);
    }

    @Override
    public void visit(IntegerValue data) {
        this.encoded_ = this.labelOf(data);
    }

    @Override
    public void visit(LongValue data) {
        this.encoded_ = this.labelOf(data);
    }

    @Override
    public void visit(NullValue data) {
        this.encoded_ = "";
    }

    @Override
    public void visit(ObjectValue data) {
        this.encoded_ = this.exploded_ ? ((Map)data.getValue()).entrySet().stream().map(entry -> this.labelOf(String.format("%s=%s", this.uriEncoded((String)entry.getKey()), SimpleValueEncoder.encode((DataValue)entry.getValue(), this.getComponent())))).collect(Collectors.joining()) : ((Map)data.getValue()).entrySet().stream().flatMap(entry -> Arrays.asList(this.uriEncoded((String)entry.getKey()), SimpleValueEncoder.encode((DataValue)entry.getValue(), this.getComponent())).stream()).map(this::labelOf).collect(Collectors.joining());
    }

    @Override
    public void visit(StringValue data) {
        this.encoded_ = this.labelOf(data);
    }
}

