/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.testwriter.encoder;

import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.cornutum.tcases.openapi.resolver.ArrayValue;
import org.cornutum.tcases.openapi.resolver.Base64Domain;
import org.cornutum.tcases.openapi.resolver.BinaryValue;
import org.cornutum.tcases.openapi.resolver.BooleanValue;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.DataValueVisitor;
import org.cornutum.tcases.openapi.resolver.DecimalValue;
import org.cornutum.tcases.openapi.resolver.IntegerValue;
import org.cornutum.tcases.openapi.resolver.LongValue;
import org.cornutum.tcases.openapi.resolver.NullValue;
import org.cornutum.tcases.openapi.resolver.ObjectValue;
import org.cornutum.tcases.openapi.resolver.StringValue;
import org.cornutum.tcases.openapi.testwriter.encoder.SimpleValueEncoder;
import org.cornutum.tcases.openapi.testwriter.encoder.UriEncoder;

public class FormUrlEncoder
implements DataValueVisitor {
    private final DataValue<?> value_;
    private final boolean encoded_;
    private final List<Map.Entry<String, String>> bindings_ = new ArrayList<Map.Entry<String, String>>();

    private FormUrlEncoder(DataValue<?> value, boolean encoded) {
        this.value_ = value;
        this.encoded_ = encoded;
    }

    public static List<Map.Entry<String, String>> encode(DataValue<?> value, boolean encoded) {
        return new FormUrlEncoder(value, encoded).accepted();
    }

    public static List<Map.Entry<String, String>> encode(DataValue<?> value) {
        return FormUrlEncoder.encode(value, true);
    }

    public static String toForm(DataValue<?> value) {
        return FormUrlEncoder.encode(value).stream().map(entry -> Optional.ofNullable(entry.getValue()).map(v -> String.format("%s=%s", entry.getKey(), v)).orElse((String)entry.getKey())).collect(Collectors.joining("&"));
    }

    private List<Map.Entry<String, String>> accepted() {
        return Optional.ofNullable(this.value_).map(value -> {
            value.accept(this);
            return this.bindings_;
        }).orElse(Collections.emptyList());
    }

    private void add(String name, String value) {
        this.bindings_.add(new AbstractMap.SimpleEntry<String, String>(name, value));
    }

    private void bind(String name, DataValue<?> data) {
        this.bind(name, data.getValue());
    }

    private void bindMember(String name, DataValue<?> member) {
        this.bind(name, member.getValue() == null ? null : SimpleValueEncoder.encode(member, UriEncoder.Component.NONE));
    }

    private void bind(String name, Object value) {
        this.add(this.urlEncoded(name), this.urlEncoded(Objects.toString(value, null)));
    }

    private String urlEncoded(String value) {
        try {
            return this.encoded_ && value != null ? URLEncoder.encode(value, "UTF-8") : value;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Can't get URL encoding for value='%s'", value), e);
        }
    }

    @Override
    public void visit(ArrayValue<?> data) {
        IntStream.range(0, ((List)data.getValue()).size()).forEach(i -> this.bindMember(String.valueOf(i), (DataValue)((List)data.getValue()).get(i)));
    }

    @Override
    public void visit(BinaryValue data) {
        this.bind("bytes", Base64Domain.encoded((byte[])data.getValue()));
    }

    @Override
    public void visit(BooleanValue data) {
        this.bind("boolean", data);
    }

    @Override
    public void visit(DecimalValue data) {
        this.bind("number", data);
    }

    @Override
    public void visit(IntegerValue data) {
        this.bind("integer", data);
    }

    @Override
    public void visit(LongValue data) {
        this.bind("integer", data);
    }

    @Override
    public void visit(NullValue data) {
    }

    @Override
    public void visit(ObjectValue data) {
        ((Map)data.getValue()).forEach((property, value) -> this.bindMember((String)property, (DataValue<?>)value));
    }

    @Override
    public void visit(StringValue data) {
        this.bind("string", data);
    }
}

