/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.testwriter.encoder;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cornutum.tcases.openapi.resolver.ArrayValue;
import org.cornutum.tcases.openapi.resolver.Base64Domain;
import org.cornutum.tcases.openapi.resolver.BinaryValue;
import org.cornutum.tcases.openapi.resolver.BooleanValue;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.DataValueVisitor;
import org.cornutum.tcases.openapi.resolver.DecimalValue;
import org.cornutum.tcases.openapi.resolver.IntegerValue;
import org.cornutum.tcases.openapi.resolver.LongValue;
import org.cornutum.tcases.openapi.resolver.NullValue;
import org.cornutum.tcases.openapi.resolver.ObjectValue;
import org.cornutum.tcases.openapi.resolver.ParamData;
import org.cornutum.tcases.openapi.resolver.StringValue;
import org.cornutum.tcases.openapi.testwriter.encoder.SimpleValueEncoder;
import org.cornutum.tcases.openapi.testwriter.encoder.UriEncoder;

public class FormParameterEncoder
extends UriEncoder
implements DataValueVisitor {
    private final String name_;
    private final String style_;
    private final boolean exploded_;
    private final DataValue<?> value_;
    private List<Map.Entry<String, String>> bindings_ = new ArrayList<Map.Entry<String, String>>();

    private FormParameterEncoder(ParamData param, UriEncoder.Component component) {
        super(component);
        this.name_ = param.getName();
        this.style_ = param.getStyle();
        this.exploded_ = param.isExploded();
        this.value_ = param.getValue();
    }

    public static List<Map.Entry<String, String>> encode(ParamData param, UriEncoder.Component component) {
        return new FormParameterEncoder(param, component).accepted();
    }

    private List<Map.Entry<String, String>> accepted() {
        return Optional.ofNullable(this.value_).map(value -> {
            value.accept(this);
            return this.bindings_;
        }).orElse(Collections.emptyList());
    }

    private void add(String name, String value) {
        this.bindings_.add(new AbstractMap.SimpleEntry<String, String>(name, value));
    }

    private void bind(String name, Object value) {
        this.add(this.uriEncoded(name), this.uriEncoded(Objects.toString(value, null)));
    }

    private void bindMember(String name, DataValue<?> member) {
        this.bind(name, member.getValue() == null ? null : SimpleValueEncoder.encode(member, UriEncoder.Component.NONE));
    }

    private void bindDeep(String property, DataValue<?> member) {
        this.bindMember(String.format("%s[%s]", this.name_, property), member);
    }

    private void bindParam(Object value) {
        this.bind(this.name_, value);
    }

    private void bindParam(DataValue<?> value) {
        this.bindParam(value.getValue());
    }

    @Override
    public void visit(ArrayValue<?> data) {
        if (((List)data.getValue()).isEmpty()) {
            this.bindParam("");
        } else if (this.exploded_) {
            ((List)data.getValue()).stream().forEach(value -> this.bindMember(this.name_, (DataValue<?>)value));
        } else {
            String delim = "pipeDelimited".equals(this.style_) ? "|" : ("spaceDelimited".equals(this.style_) ? " " : ",");
            this.bindParam(((List)data.getValue()).stream().map(item -> SimpleValueEncoder.encode(item, UriEncoder.Component.NONE)).collect(Collectors.joining(delim)));
        }
    }

    @Override
    public void visit(BinaryValue data) {
        this.bindParam(Base64Domain.encoded((byte[])data.getValue()));
    }

    @Override
    public void visit(BooleanValue data) {
        this.bindParam(data);
    }

    @Override
    public void visit(DecimalValue data) {
        this.bindParam(data);
    }

    @Override
    public void visit(IntegerValue data) {
        this.bindParam(data);
    }

    @Override
    public void visit(LongValue data) {
        this.bindParam(data);
    }

    @Override
    public void visit(NullValue data) {
        this.bindParam(data);
    }

    @Override
    public void visit(ObjectValue data) {
        if ("deepObject".equals(this.style_)) {
            ((Map)data.getValue()).forEach((property, value) -> this.bindDeep((String)property, (DataValue<?>)value));
        } else if (this.exploded_) {
            ((Map)data.getValue()).forEach((property, value) -> this.bindMember((String)property, (DataValue<?>)value));
        } else {
            this.bindParam(((Map)data.getValue()).entrySet().stream().flatMap(entry -> Arrays.asList((String)entry.getKey(), SimpleValueEncoder.encode((DataValue)entry.getValue(), UriEncoder.Component.NONE)).stream()).collect(Collectors.joining(",")));
        }
    }

    @Override
    public void visit(StringValue data) {
        this.bindParam(data);
    }
}

